/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.tesslocator.block.part;

import com.latmod.mods.itemfilters.api.ItemFiltersAPI;
import com.latmod.mods.tesslocator.TesslocatorConfig;
import com.latmod.mods.tesslocator.block.TileTesslocator;
import com.latmod.mods.tesslocator.block.part.BasicTesslocatorPart;
import com.latmod.mods.tesslocator.block.part.EnumPartType;
import com.latmod.mods.tesslocator.block.part.TesslocatorPart;
import com.latmod.mods.tesslocator.data.TessNet;
import com.latmod.mods.tesslocator.gui.ContainerBasicItemTesslocator;
import com.latmod.mods.tesslocator.gui.GuiBasicItemTesslocator;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class BasicItemTesslocatorPart
extends BasicTesslocatorPart
implements IItemHandler {
    private final BasicItemTesslocatorPart[] temp = new BasicItemTesslocatorPart[5];
    public static boolean ignoreMarkDirty = false;
    public ItemStack inputFilter = ItemStack.field_190927_a;
    public ItemStack outputFilter = ItemStack.field_190927_a;
    public final ItemStackHandler other = new ItemStackHandler(2){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.isItemValid(slot, stack) ? super.insertItem(slot, stack, simulate) : stack;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0) {
                return stack.func_77973_b() == Items.field_151114_aO;
            }
            if (slot == 1) {
                return stack.func_77973_b() == Items.field_151045_i;
            }
            return false;
        }

        public int getStackLimit(int slot, ItemStack stack) {
            if (slot == 0) {
                return TesslocatorConfig.basic_item.speed_boost_max;
            }
            if (slot == 1) {
                return TesslocatorConfig.basic_item.stack_boost_max;
            }
            return 0;
        }

        protected void onContentsChanged(int slot) {
            if (!ignoreMarkDirty) {
                BasicItemTesslocatorPart.this.block.func_70296_d();
            }
        }
    };
    public int currentSlot = 0;
    public int cooldown = 0;
    public int currentPart = 0;

    public BasicItemTesslocatorPart(TileTesslocator t, EnumFacing f) {
        super(t, f);
    }

    @Override
    public EnumPartType getType() {
        return EnumPartType.BASIC_ITEM;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        if (!this.inputFilter.func_190926_b()) {
            nbt.func_74782_a("input_filter", (NBTBase)this.inputFilter.serializeNBT());
        }
        if (!this.outputFilter.func_190926_b()) {
            nbt.func_74782_a("output_filter", (NBTBase)this.outputFilter.serializeNBT());
        }
        NBTTagList otherTag = new NBTTagList();
        for (int i = 0; i < this.other.getSlots(); ++i) {
            if (this.other.getStackInSlot(i).func_190926_b()) continue;
            NBTTagCompound nbt1 = this.other.getStackInSlot(i).serializeNBT();
            nbt1.func_74774_a("slot", (byte)i);
            otherTag.func_74742_a((NBTBase)nbt1);
        }
        if (!otherTag.func_82582_d()) {
            nbt.func_74782_a("other", (NBTBase)otherTag);
        }
        if (this.currentSlot > 0) {
            nbt.func_74768_a("current_slot", this.currentSlot);
        }
        if (this.cooldown > 0) {
            nbt.func_74774_a("cooldown", (byte)this.cooldown);
        }
        if (this.currentPart > 0) {
            nbt.func_74774_a("current_part", (byte)this.currentPart);
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.inputFilter = nbt.func_74764_b("input_filter") ? new ItemStack(nbt.func_74775_l("input_filter")) : ItemStack.field_190927_a;
        this.outputFilter = nbt.func_74764_b("output_filter") ? new ItemStack(nbt.func_74775_l("output_filter")) : ItemStack.field_190927_a;
        this.other.setSize(2);
        NBTTagList otherTag = nbt.func_150295_c("other", 10);
        for (int i = 0; i < otherTag.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = otherTag.func_150305_b(i);
            ItemStack stack = new ItemStack(nbt1);
            if (stack.func_190926_b()) continue;
            ignoreMarkDirty = true;
            this.other.setStackInSlot((int)nbt1.func_74771_c("slot"), stack);
            ignoreMarkDirty = false;
        }
        if (otherTag.func_82582_d()) {
            int speedBoost = nbt.func_74771_c("boost") & 0xFF;
            int stackBoost = nbt.func_74771_c("stack") & 0xFF;
            if (speedBoost > 0) {
                this.other.setStackInSlot(0, new ItemStack(Items.field_151114_aO, speedBoost));
            }
            if (stackBoost > 0) {
                this.other.setStackInSlot(1, new ItemStack(Items.field_151045_i, stackBoost));
            }
        }
        this.currentSlot = nbt.func_74762_e("current_slot");
        if (this.currentSlot < 0) {
            this.currentSlot = 0;
        }
        this.cooldown = nbt.func_74771_c("cooldown") & 0xFF;
        this.currentPart = nbt.func_74771_c("current_part") & 0xFF;
    }

    @Override
    public boolean hasCapability(Capability<?> capability) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this : null);
    }

    @Override
    public void update(TessNet net) {
        if (this.mode == 0) {
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        this.cooldown = TesslocatorConfig.basic_item.speed_boost_starting - (int)((double)this.other.getStackInSlot(0).func_190916_E() * TesslocatorConfig.basic_item.speed_boost_multiplier);
        this.moveItems();
    }

    private void moveItems() {
        int tempParts = 0;
        for (TesslocatorPart part : this.block.parts) {
            if (part == this || !(part instanceof BasicItemTesslocatorPart)) continue;
            BasicItemTesslocatorPart part1 = (BasicItemTesslocatorPart)part;
            if (part1.mode == 1) continue;
            this.temp[tempParts] = part1;
            ++tempParts;
        }
        if (tempParts == 0) {
            return;
        }
        TileEntity tileEntity = this.getFacingTile();
        if (tileEntity == null) {
            return;
        }
        IItemHandler handler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.facing.func_176734_d());
        if (handler == null) {
            return;
        }
        int slots = handler.getSlots();
        if (slots <= 0) {
            return;
        }
        int stackBoost = this.other.getStackInSlot(1).func_190916_E() + 1;
        for (int x = 0; x < stackBoost; ++x) {
            ItemStack stack1;
            IItemHandler outHandler;
            TileEntity outEntity;
            ItemStack stack;
            this.currentSlot %= slots;
            int originalSlot = this.currentSlot;
            if (originalSlot < 0) {
                originalSlot = 0;
            }
            while ((stack = handler.extractItem(this.currentSlot, 64, true)) == ItemStack.field_190927_a || stack.func_190926_b() || !ItemFiltersAPI.filter((ItemStack)this.outputFilter, (ItemStack)stack)) {
                this.currentSlot = (this.currentSlot + 1) % slots;
                if (this.currentSlot != originalSlot) continue;
                return;
            }
            if (stack.func_190926_b()) {
                return;
            }
            int i = this.currentPart % tempParts;
            if (ItemFiltersAPI.filter((ItemStack)this.temp[i].inputFilter, (ItemStack)stack) && (outEntity = this.temp[i].getFacingTile()) != null && (outHandler = (IItemHandler)outEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.temp[i].facing.func_176734_d())) != null && (stack1 = ItemHandlerHelper.insertItem((IItemHandler)outHandler, (ItemStack)stack, (boolean)false)).func_190916_E() != stack.func_190916_E()) {
                handler.extractItem(this.currentSlot, stack.func_190916_E() - stack1.func_190916_E(), false);
            }
            ++this.currentSlot;
            ++this.currentPart;
            if (this.currentPart < 256) continue;
            this.currentPart = 0;
        }
    }

    @Override
    public void drop(World world, BlockPos pos) {
        super.drop(world, pos);
        for (int i = 0; i < this.other.getSlots(); ++i) {
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.other.getStackInSlot(i));
        }
    }

    @Override
    @Nullable
    public Container getGuiContainer(EntityPlayer player) {
        return new ContainerBasicItemTesslocator(this, player);
    }

    @Override
    @Nullable
    public Object getGuiScreen(Container container) {
        return new GuiBasicItemTesslocator((ContainerBasicItemTesslocator)container);
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return ItemStack.field_190927_a;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        IItemHandler outHandler;
        TileEntity outEntity;
        int tempParts = 0;
        for (TesslocatorPart part : this.block.parts) {
            if (part == this || !(part instanceof BasicItemTesslocatorPart)) continue;
            BasicItemTesslocatorPart part1 = (BasicItemTesslocatorPart)part;
            if (part1.mode == 1) continue;
            this.temp[tempParts] = part1;
            ++tempParts;
        }
        if (tempParts == 0) {
            return stack;
        }
        int i = this.currentPart % tempParts;
        if (ItemFiltersAPI.filter((ItemStack)this.temp[i].inputFilter, (ItemStack)stack) && (outEntity = this.block.func_145831_w().func_175625_s(this.block.func_174877_v().func_177972_a(this.temp[i].facing))) != null && (outHandler = (IItemHandler)outEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.temp[i].facing.func_176734_d())) != null) {
            ++this.currentPart;
            if (this.currentPart >= 256) {
                this.currentPart = 0;
            }
            return ItemHandlerHelper.insertItem((IItemHandler)outHandler, (ItemStack)stack, (boolean)simulate);
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }
}

