/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.tesslocator.block.part;

import com.latmod.mods.tesslocator.Tesslocator;
import com.latmod.mods.tesslocator.block.TileTesslocator;
import com.latmod.mods.tesslocator.block.part.EnumPartType;
import com.latmod.mods.tesslocator.data.TessNet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public abstract class TesslocatorPart {
    public final TileTesslocator block;
    public final EnumFacing facing;
    private TileEntity facingTile;

    public TesslocatorPart(TileTesslocator t, EnumFacing f) {
        this.block = t;
        this.facing = f;
        this.facingTile = null;
    }

    public abstract EnumPartType getType();

    public void writeData(NBTTagCompound nbt) {
    }

    public void readData(NBTTagCompound nbt) {
    }

    public void clearCache() {
        this.facingTile = null;
    }

    public abstract boolean hasCapability(Capability<?> var1);

    @Nullable
    public abstract <T> T getCapability(Capability<T> var1);

    public abstract void update(TessNet var1);

    public int getColor(int layer) {
        return -1;
    }

    public void onRightClick(EntityPlayer player, EnumHand hand) {
    }

    public void onPlaced(EntityPlayer player, ItemStack stack) {
    }

    public void drop(World world, BlockPos pos) {
        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(this.getType().item.get()));
    }

    public final void openGui(EntityPlayer player) {
        player.openGui((Object)Tesslocator.INSTANCE, this.facing.func_176745_a(), this.block.func_145831_w(), this.block.func_174877_v().func_177958_n(), this.block.func_174877_v().func_177956_o(), this.block.func_174877_v().func_177952_p());
    }

    @Nullable
    public Container getGuiContainer(EntityPlayer player) {
        return null;
    }

    @Nullable
    public Object getGuiScreen(Container container) {
        return null;
    }

    @Nullable
    public TileEntity getFacingTile() {
        if (this.facingTile != null && !this.facingTile.func_145837_r()) {
            return this.facingTile;
        }
        this.facingTile = this.block.func_145831_w().func_175625_s(this.block.func_174877_v().func_177972_a(this.facing));
        return this.facingTile;
    }
}

