/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.tesslocator.data;

import com.mojang.util.UUIDTypeAdapter;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;

public final class TessNetKey {
    public static final UUID UUID_00 = new UUID(0L, 0L);
    public final long ownerMost;
    public final long ownerLeast;
    public final int colors;

    public static UUID uuid(long m, long l) {
        if (m == 0L && l == 0L) {
            return UUID_00;
        }
        return new UUID(m, l);
    }

    public TessNetKey(long m, long l, int c) {
        this.ownerMost = m;
        this.ownerLeast = l;
        this.colors = c & 0xFF;
    }

    public TessNetKey(NBTTagCompound nbt) {
        this(nbt.func_74763_f("owner_most"), nbt.func_74763_f("owner_least"), nbt.func_74771_c("colors"));
    }

    public void write(NBTTagCompound nbt) {
        nbt.func_74772_a("owner_most", this.ownerMost);
        nbt.func_74772_a("owner_least", this.ownerLeast);
        nbt.func_74774_a("colors", (byte)this.colors);
    }

    public UUID getUUID() {
        return TessNetKey.uuid(this.ownerMost, this.ownerLeast);
    }

    public int getColorA() {
        return this.colors & 0xF;
    }

    public int getColorB() {
        return this.colors >> 4 & 0xF;
    }

    public int hashCode() {
        int h = this.colors;
        h = h * 31 + Long.hashCode(this.ownerMost);
        h = h * 31 + Long.hashCode(this.ownerLeast);
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TessNetKey) {
            TessNetKey key = (TessNetKey)obj;
            return this.ownerMost == key.ownerMost && this.ownerLeast == key.ownerLeast && this.colors == key.colors;
        }
        return false;
    }

    public String toString() {
        return UUIDTypeAdapter.fromUUID((UUID)this.getUUID()) + ":" + Integer.toHexString(this.getColorA()) + Integer.toHexString(this.getColorB());
    }
}

