/*
 * Decompiled with CFR 0.152.
 */
package com.thewhoareyouperson.soundreloader;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.versioning.ComparableVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;

@Mod(name="Sound Reloader", modid="soundreloader", version="1.1", acceptedMinecraftVersions="[1.12.2]")
public class SoundReloaderMod {
    public static final String NAME = "Sound Reloader";
    public static final String MODID = "soundreloader";
    public static final String VERSION = "1.1";
    public static final Logger Logger = LogManager.getLogger((String)"soundreloader");
    public static final String ERROR_STRING = "Sound Reloader cannot access the minecraft version, and subsequently, the sound system. This mod will be inactive.";
    public static final List<String> SUPPORTED_VERSIONS = Arrays.asList("1.7.10", "1.8.9", "1.10.2", "1.11.2", "1.12.2");
    private static final String DEFAULT_MAPPING = "field_147694_f";
    private static boolean modInactive = false;
    private static String cachedMCVersionString;
    private static ComparableVersion cachedMCVersionObj;
    protected static final boolean debug;
    protected static final boolean devEnv;
    protected static KeyBinding soundBinding;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        ComparableVersion mcVersion = SoundReloaderMod.getMcVersion();
        if (!modInactive) {
            Logger.info("Minecraft version: '" + mcVersion + "'");
            if (!SUPPORTED_VERSIONS.contains(mcVersion.toString())) {
                Logger.warn("This mod is using an unsupported version of Minecraft. It may still work, but it is recommended to try to update to a version that supports it.");
            }
            Logger.info("Registering Keybindings");
            if (devEnv) {
                Logger.info("Running in Development (Deobfuscated) Environment");
            }
            soundBinding = new KeyBinding("Reload Default Sound Device", 25, "key.categories.misc");
            ClientRegistry.registerKeyBinding((KeyBinding)soundBinding);
            if (mcVersion.compareTo(new ComparableVersion("1.7.10")) <= 0) {
                if (debug) {
                    Logger.info("Using legacy (1.7.10 and lower) event bus access.");
                }
                FMLCommonHandler.instance().bus().register((Object)new KeyInputHandler());
            } else {
                if (debug) {
                    Logger.info("Using current(?) event bus access.");
                }
                MinecraftForge.EVENT_BUS.register((Object)new KeyInputHandler());
            }
        }
    }

    protected static ComparableVersion getMcVersion() {
        block11: {
            if (cachedMCVersionString == null) {
                Class<MinecraftForge> mcfClass = MinecraftForge.class;
                String versionFieldName = "MC_VERSION";
                try {
                    Field fldMcVersion = mcfClass.getField(versionFieldName);
                    if (fldMcVersion != null) {
                        cachedMCVersionString = (String)fldMcVersion.get(null);
                    }
                }
                catch (RuntimeException e) {
                    Logger.error((Message)new ParameterizedMessage("Cannot get {0} from {1} for some reason!", new Object[]{versionFieldName, mcfClass.getCanonicalName()}, (Throwable)e));
                }
                catch (NoSuchFieldException e) {
                    Logger.error((Message)new ParameterizedMessage("Cannot find {0} from {1}!", new Object[]{versionFieldName, mcfClass.getCanonicalName()}, (Throwable)e));
                }
                catch (IllegalAccessException e) {
                    Logger.error((Message)new ParameterizedMessage("Cannot access {0} from {1}!", new Object[]{versionFieldName, mcfClass.getCanonicalName()}, (Throwable)e));
                }
                finally {
                    if (cachedMCVersionString != null) break block11;
                    Logger.warn(ERROR_STRING);
                    modInactive = true;
                    return null;
                }
            }
        }
        return cachedMCVersionObj != null ? cachedMCVersionObj : (cachedMCVersionObj = new ComparableVersion(cachedMCVersionString));
    }

    static {
        debug = System.getProperty("minecraft.soundreloader.debug") != null;
        devEnv = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    }

    public static class KeyInputHandler {
        private static SoundManager cachedManager = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SubscribeEvent
        public void onKeyInput(InputEvent.KeyInputEvent event) {
            if (!modInactive && soundBinding.func_151468_f()) {
                Logger.info("Reloading sound system...");
                if (cachedManager == null) {
                    SoundHandler handler = Minecraft.func_71410_x().func_147118_V();
                    SoundManager mngr = null;
                    Exception ex = null;
                    try {
                        if (debug) {
                            for (Field fd : SoundHandler.class.getDeclaredFields()) {
                                Logger.info("SoundHandler Field: '" + fd.getName() + "' of type '" + fd.getType() + "'");
                            }
                        }
                        Field fi = SoundHandler.class.getDeclaredField(devEnv ? "sndManager" : SoundReloaderMod.DEFAULT_MAPPING);
                        fi.setAccessible(true);
                        mngr = (SoundManager)fi.get(handler);
                    }
                    catch (NoSuchFieldException e) {
                        ex = e;
                    }
                    catch (SecurityException e) {
                        ex = e;
                    }
                    catch (IllegalArgumentException e) {
                        ex = e;
                    }
                    catch (IllegalAccessException e) {
                        ex = e;
                    }
                    finally {
                        if (ex != null) {
                            ex.printStackTrace();
                        }
                    }
                    cachedManager = mngr;
                }
                if (cachedManager != null) {
                    cachedManager.func_148596_a();
                    Logger.info("Reloaded sound system");
                } else {
                    Logger.warn("Unable to get sound manager, shutting down mod.");
                    modInactive = true;
                }
            }
        }
    }
}

