/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.skygrid.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import funwayguy.skygrid.config.GridBlock;
import funwayguy.skygrid.core.SkyGrid;
import funwayguy.skygrid.util.JsonHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBarrier;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockStem;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.common.Loader;
import org.apache.logging.log4j.Level;

public class GridRegistry {
    public static final List<GridBlock> blocksOverworld = new ArrayList<GridBlock>();
    public static final List<GridBlock> blocksNether = new ArrayList<GridBlock>();
    public static final List<GridBlock> blocksEnd = new ArrayList<GridBlock>();
    public static final List<GridBlock> blocksAbyssalWasteland = new ArrayList<GridBlock>();
    public static final List<GridBlock> blocksDreadlands = new ArrayList<GridBlock>();
    public static final List<GridBlock> blocksOmothol = new ArrayList<GridBlock>();
    public static final List<GridBlock> blocksDarkRealm = new ArrayList<GridBlock>();
    public static final Map<String, GridCache> randomCache = new HashMap<String, GridCache>();
    private static GridBlock fallback = new GridBlock(Blocks.field_150357_h);
    private static List<GridBlock> defBlockList;
    private static JsonArray defBlockJson;

    public static List<GridBlock> getRandom(Random rand, List<GridBlock> list, Biome biome, int dimension, int amount) {
        String key = dimension + (biome == null ? "" : "," + Biome.func_185362_a((Biome)biome));
        GridCache cache = randomCache.get(key);
        if (cache != null) {
            return GridRegistry.getRandom(rand, cache, amount);
        }
        List<GridBlock> tmp = list;
        if (biome != null) {
            tmp = new ArrayList<GridBlock>();
            int biomeID = Biome.func_185362_a((Biome)biome);
            for (GridBlock gb : list) {
                if (gb == null || gb.biomes != null && gb.biomes.size() > 0 && !gb.biomes.contains(biomeID)) continue;
                tmp.add(gb);
            }
        }
        cache = new GridCache(tmp, GridRegistry.getTotalWeight(tmp));
        randomCache.put(key, cache);
        return GridRegistry.getRandom(rand, cache, amount);
    }

    private static List<GridBlock> getRandom(Random rand, GridCache cache, int amount) {
        ArrayList<Float> picks = new ArrayList<Float>();
        for (int i = 0; i < amount; ++i) {
            picks.add(Float.valueOf(rand.nextFloat() * (float)cache.weight));
        }
        picks.sort(Comparator.naturalOrder());
        ArrayList<GridBlock> blocks = new ArrayList<GridBlock>();
        int cnt = 0;
        int n = 0;
        for (GridBlock entry : cache.list) {
            if (n >= amount) break;
            cnt += entry.weight;
            while (n < amount && (float)cnt >= ((Float)picks.get(n)).floatValue()) {
                blocks.add(entry);
                ++n;
            }
        }
        if (blocks.size() <= 0) {
            blocks.add(fallback);
        }
        Collections.shuffle(blocks, rand);
        return blocks;
    }

    private static int getTotalWeight(List<GridBlock> list) {
        int t = 0;
        for (GridBlock g : list) {
            t += g.weight;
        }
        return t;
    }

    public static void loadBlocks() {
        JsonArray list;
        randomCache.clear();
        String preFix = "config/skygrid/";
        File f = new File("config/skygrid/overworld.json");
        blocksOverworld.clear();
        if (!f.exists()) {
            GridRegistry.generateDefaults(f, blocksOverworld);
        } else {
            list = JsonHelper.ReadArrayFromFile(f);
            for (JsonElement e : list) {
                if (e == null || !e.isJsonObject()) continue;
                blocksOverworld.add(new GridBlock(e.getAsJsonObject()));
            }
        }
        SkyGrid.logger.log(Level.INFO, "Loaded " + blocksOverworld.size() + " Overworld grid blocks");
        f = new File("config/skygrid/nether.json");
        blocksNether.clear();
        if (!f.exists()) {
            GridRegistry.generateDefaults(f, blocksNether);
        } else {
            list = JsonHelper.ReadArrayFromFile(f);
            for (JsonElement e : list) {
                if (e == null || !e.isJsonObject()) continue;
                blocksNether.add(new GridBlock(e.getAsJsonObject()));
            }
        }
        SkyGrid.logger.log(Level.INFO, "Loaded " + blocksNether.size() + " Nether grid blocks");
        f = new File("config/skygrid/end.json");
        blocksEnd.clear();
        if (!f.exists()) {
            GridRegistry.generateDefaults(f, blocksEnd);
        } else {
            list = JsonHelper.ReadArrayFromFile(f);
            for (JsonElement e : list) {
                if (e == null || !e.isJsonObject()) continue;
                blocksEnd.add(new GridBlock(e.getAsJsonObject()));
            }
        }
        SkyGrid.logger.log(Level.INFO, "Loaded " + blocksEnd.size() + " End grid blocks");
        if (Loader.isModLoaded((String)"abyssalcraft")) {
            f = new File("config/skygrid/abyssal_wasteland.json");
            blocksAbyssalWasteland.clear();
            if (!f.exists()) {
                GridRegistry.generateDefaults(f, blocksAbyssalWasteland);
            } else {
                list = JsonHelper.ReadArrayFromFile(f);
                for (JsonElement e : list) {
                    if (e == null || !e.isJsonObject()) continue;
                    blocksAbyssalWasteland.add(new GridBlock(e.getAsJsonObject()));
                }
            }
            SkyGrid.logger.log(Level.INFO, "Loaded " + blocksAbyssalWasteland.size() + " Abyssal Wasteland grid blocks");
            f = new File("config/skygrid/dreadlands.json");
            blocksDreadlands.clear();
            if (!f.exists()) {
                GridRegistry.generateDefaults(f, blocksDreadlands);
            } else {
                list = JsonHelper.ReadArrayFromFile(f);
                for (JsonElement e : list) {
                    if (e == null || !e.isJsonObject()) continue;
                    blocksDreadlands.add(new GridBlock(e.getAsJsonObject()));
                }
            }
            SkyGrid.logger.log(Level.INFO, "Loaded " + blocksDreadlands.size() + " Dreadlands grid blocks");
            f = new File("config/skygrid/omothol.json");
            blocksOmothol.clear();
            if (!f.exists()) {
                GridRegistry.generateDefaults(f, blocksOmothol);
            } else {
                list = JsonHelper.ReadArrayFromFile(f);
                for (JsonElement e : list) {
                    if (e == null || !e.isJsonObject()) continue;
                    blocksOmothol.add(new GridBlock(e.getAsJsonObject()));
                }
            }
            SkyGrid.logger.log(Level.INFO, "Loaded " + blocksOmothol.size() + " Omothol grid blocks");
            f = new File("config/skygrid/dark_realm.json");
            blocksDarkRealm.clear();
            if (!f.exists()) {
                GridRegistry.generateDefaults(f, blocksDarkRealm);
            } else {
                list = JsonHelper.ReadArrayFromFile(f);
                for (JsonElement e : list) {
                    if (e == null || !e.isJsonObject()) continue;
                    blocksDarkRealm.add(new GridBlock(e.getAsJsonObject()));
                }
            }
            SkyGrid.logger.log(Level.INFO, "Loaded " + blocksDarkRealm.size() + " Dark Realm grid blocks");
        }
    }

    public static void generateDefaults(File f, List<GridBlock> blocklist) {
        if (defBlockList != null) {
            blocklist.addAll(defBlockList);
            JsonHelper.WriteToFile(f, (JsonElement)defBlockJson);
            return;
        }
        defBlockList = new ArrayList<GridBlock>();
        GridBlock farmland = new GridBlock(Blocks.field_150458_ak);
        GridBlock soulsand = new GridBlock(Blocks.field_150425_aM);
        GridBlock plainsand = new GridBlock((Block)Blocks.field_150354_m);
        GridBlock grass = new GridBlock((Block)Blocks.field_150349_c);
        JsonArray list = new JsonArray();
        for (Block b : Block.field_149771_c) {
            if (b == Blocks.field_150349_c || b == Blocks.field_150354_m || b == Blocks.field_150425_aM || b == Blocks.field_150458_ak || b instanceof BlockCommandBlock || b instanceof BlockBarrier || b instanceof BlockLiquid || b instanceof BlockFluidBase || b instanceof BlockIce || !b.func_176223_P().func_185917_h() && b != Blocks.field_150486_ae) continue;
            if (b instanceof BlockCrops || b instanceof BlockStem) {
                farmland.addPlant(b);
                continue;
            }
            if (b instanceof BlockNetherWart) {
                soulsand.addPlant(b);
                continue;
            }
            if (b instanceof BlockCactus || b instanceof BlockReed) {
                plainsand.addPlant(b);
                continue;
            }
            if (b instanceof IPlantable) {
                grass.addPlant(b);
                continue;
            }
            GridBlock tmp = new GridBlock(b);
            list.add((JsonElement)tmp.writeToJson(new JsonObject()));
            defBlockList.add(tmp);
        }
        list.add((JsonElement)farmland.writeToJson(new JsonObject()));
        list.add((JsonElement)soulsand.writeToJson(new JsonObject()));
        list.add((JsonElement)plainsand.writeToJson(new JsonObject()));
        list.add((JsonElement)grass.writeToJson(new JsonObject()));
        defBlockList.add(farmland);
        defBlockList.add(soulsand);
        defBlockList.add(plainsand);
        defBlockList.add(grass);
        defBlockJson = list;
        blocklist.addAll(defBlockList);
        JsonHelper.WriteToFile(f, (JsonElement)defBlockJson);
    }

    public static class GridCache {
        private final List<GridBlock> list;
        private final int weight;

        private GridCache(List<GridBlock> list, int weight) {
            this.list = list;
            this.weight = weight;
        }
    }
}

