/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.gravisuit.items.armor;

import ic2.core.IC2;
import ic2.core.item.armor.base.ItemArmorJetpackBase;
import ic2.core.item.armor.electric.ItemArmorNanoSuit;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.obj.ToolTipType;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinsdar.gravisuit.util.Config;

public class ItemArmorAdvancedNanoChestplate
extends ItemArmorNanoSuit
implements ItemArmorJetpackBase.IIndirectJetpack {
    ItemArmorJetpackBase jetpack;
    String texture;
    int index;

    public ItemArmorAdvancedNanoChestplate(ItemArmorJetpackBase jetpack, String name, LocaleComp comp, String tex, int index) {
        super(44, EntityEquipmentSlot.CHEST);
        this.setRegistryName(name.toLowerCase());
        this.setUnlocalizedName(comp);
        this.func_77637_a(IC2.tabIC2);
        this.jetpack = jetpack;
        this.texture = tex;
        this.index = index;
        this.transferLimit = Config.advancedNanoChestplateTransfer;
        this.maxCharge = Config.advancedNanoChestplateStorage;
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    public void setMaxCharge(int storage) {
        this.maxCharge = storage;
    }

    public void setMaxTransfer(int maxTransfer) {
        this.transferLimit = maxTransfer;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int i) {
        return Ic2Icons.getTextures((String)"gravisuit_items")[this.index];
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public String getTexture() {
        return "gravisuit:textures/models/" + this.texture;
    }

    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        this.jetpack.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        super.onArmorTick(world, player, itemStack);
        this.jetpack.onArmorTick(world, player, itemStack);
    }

    public ItemArmorJetpackBase getJetpack() {
        return this.jetpack;
    }
}

