/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tools;

import com.direwolf20.buildinggadgets.client.RemoteInventoryCache;
import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.blocks.ModBlocks;
import com.direwolf20.buildinggadgets.common.items.FakeBuilderWorld;
import com.direwolf20.buildinggadgets.common.items.ModItems;
import com.direwolf20.buildinggadgets.common.items.capability.CapabilityProviderEnergy;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetDestruction;
import com.direwolf20.buildinggadgets.common.tools.BlockMap;
import com.direwolf20.buildinggadgets.common.tools.BuildingModes;
import com.direwolf20.buildinggadgets.common.tools.ExchangingModes;
import com.direwolf20.buildinggadgets.common.tools.GadgetUtils;
import com.direwolf20.buildinggadgets.common.tools.InventoryManipulation;
import com.direwolf20.buildinggadgets.common.tools.PasteToolBufferBuilder;
import com.direwolf20.buildinggadgets.common.tools.Sorter;
import com.direwolf20.buildinggadgets.common.tools.ToolDireBuffer;
import com.direwolf20.buildinggadgets.common.tools.UniqueItem;
import com.direwolf20.buildinggadgets.common.tools.UniqueItemStack;
import com.direwolf20.buildinggadgets.common.tools.VectorTools;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Multiset;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.energy.CapabilityEnergy;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.lwjgl.opengl.GL14;

public class ToolRenders {
    private static final FakeBuilderWorld fakeWorld = new FakeBuilderWorld();
    private static Minecraft mc = Minecraft.func_71410_x();
    private static RemoteInventoryCache cacheInventory = new RemoteInventoryCache(false);
    private static Cache<Triple<UniqueItemStack, BlockPos, Integer>, Integer> cacheDestructionOverlay = CacheBuilder.newBuilder().maximumSize(1L).expireAfterWrite(1L, TimeUnit.SECONDS).removalListener(removal -> GLAllocation.func_74523_b((int)((Integer)removal.getValue()))).build();
    private static final IBlockState stainedGlassYellow = Blocks.field_150399_cn.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)EnumDyeColor.YELLOW);
    private static final IBlockState stainedGlassRed = Blocks.field_150399_cn.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)EnumDyeColor.RED);
    private static final IBlockState stainedGlassWhite = Blocks.field_150399_cn.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)EnumDyeColor.WHITE);

    public static void setInventoryCache(Multiset<UniqueItem> cache) {
        cacheInventory.setCache(cache);
    }

    public static void updateInventoryCache() {
        cacheInventory.forceUpdate();
    }

    public static void renderBuilderOverlay(RenderWorldLastEvent evt, EntityPlayer player, ItemStack heldItem) {
        Vec3d playerPos = Utils.getPlayerTranslate(player, evt.getPartialTicks());
        ToolRenders.renderLinkedInventoryOutline(heldItem, playerPos, player);
        RayTraceResult lookingAt = VectorTools.getLookingAt(player, heldItem);
        IBlockState state = Blocks.field_150350_a.func_176223_P();
        List<BlockPos> coordinates = GadgetUtils.getAnchor(heldItem);
        if (lookingAt == null && coordinates.size() == 0) {
            return;
        }
        IBlockState startBlock = Utils.getStartBlock(lookingAt, player);
        if (startBlock == ModBlocks.effectBlock.func_176223_P()) {
            return;
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        IBlockState renderBlockState = GadgetUtils.getToolBlock(heldItem);
        if (renderBlockState == Blocks.field_150350_a.func_176223_P()) {
            return;
        }
        if (coordinates.size() == 0 && lookingAt != null) {
            coordinates = BuildingModes.collectPlacementPos(player.field_70170_p, player, lookingAt.func_178782_a(), lookingAt.field_178784_b, heldItem, lookingAt.func_178782_a());
        }
        ItemStack itemStack = Utils.getSilkDropIfPresent(player.field_70170_p, renderBlockState, player);
        long hasBlocks = InventoryManipulation.countItem(itemStack, player, cacheInventory);
        hasBlocks += (long)InventoryManipulation.countPaste(player);
        int hasEnergy = Utils.getStackEnergy(heldItem, player);
        HashSet<BlockPos> coords = new HashSet<BlockPos>(coordinates);
        fakeWorld.setWorldAndState(player.field_70170_p, renderBlockState, coords);
        GlStateManager.func_179094_E();
        Utils.stateManagerPrepareBlend();
        List<BlockPos> sortedCoordinates = Sorter.Blocks.byDistance(coordinates, player);
        for (BlockPos coordinate : sortedCoordinates) {
            GlStateManager.func_179094_E();
            Utils.stateManagerPrepare(playerPos, coordinate, null);
            GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.55f);
            if (fakeWorld.func_175624_G() != WorldType.field_180272_g) {
                state = renderBlockState.func_185899_b((IBlockAccess)fakeWorld, coordinate);
            }
            mc.func_175602_ab().func_175016_a(state, 1.0f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            Utils.stateManagerPrepare(playerPos, coordinate, Float.valueOf(0.01f));
            GlStateManager.func_179152_a((float)1.006f, (float)1.006f, (float)1.006f);
            GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.35f);
            hasEnergy = heldItem.hasCapability(CapabilityEnergy.ENERGY, null) ? (hasEnergy -= ModItems.gadgetBuilding.getEnergyCost(heldItem)) : (hasEnergy -= ModItems.gadgetBuilding.getDamageCost(heldItem));
            if (--hasBlocks < 0L || hasEnergy < 0) {
                mc.func_175602_ab().func_175016_a(stainedGlassRed, 1.0f);
            }
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179112_b((int)770, (int)771);
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)MinecraftForgeClient.getRenderLayer());
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public static void renderExchangerOverlay(RenderWorldLastEvent evt, EntityPlayer player, ItemStack heldItem) {
        Vec3d playerPos = Utils.getPlayerTranslate(player, evt.getPartialTicks());
        BlockRendererDispatcher dispatcher = mc.func_175602_ab();
        ToolRenders.renderLinkedInventoryOutline(heldItem, playerPos, player);
        RayTraceResult lookingAt = VectorTools.getLookingAt(player, heldItem);
        IBlockState state = Blocks.field_150350_a.func_176223_P();
        List<BlockPos> coordinates = GadgetUtils.getAnchor(heldItem);
        if (lookingAt == null && coordinates.size() == 0) {
            return;
        }
        IBlockState startBlock = Utils.getStartBlock(lookingAt, player);
        if (startBlock == ModBlocks.effectBlock.func_176223_P()) {
            return;
        }
        IBlockState renderBlockState = GadgetUtils.getToolBlock(heldItem);
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        if (renderBlockState == Blocks.field_150350_a.func_176223_P()) {
            return;
        }
        if (coordinates.size() == 0 && lookingAt != null) {
            coordinates = ExchangingModes.collectPlacementPos(player.field_70170_p, player, lookingAt.func_178782_a(), lookingAt.field_178784_b, heldItem, lookingAt.func_178782_a());
        }
        ItemStack itemStack = Utils.getSilkDropIfPresent(player.field_70170_p, renderBlockState, player);
        long hasBlocks = InventoryManipulation.countItem(itemStack, player, cacheInventory);
        hasBlocks += (long)InventoryManipulation.countPaste(player);
        int hasEnergy = Utils.getStackEnergy(heldItem, player);
        HashSet<BlockPos> coords = new HashSet<BlockPos>(coordinates);
        fakeWorld.setWorldAndState(player.field_70170_p, renderBlockState, coords);
        GlStateManager.func_179094_E();
        Utils.stateManagerPrepareBlend();
        for (BlockPos coordinate : coordinates) {
            GlStateManager.func_179094_E();
            Utils.stateManagerPrepare(playerPos, coordinate, Float.valueOf(0.001f));
            GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.55f);
            if (fakeWorld.func_175624_G() != WorldType.field_180272_g) {
                state = renderBlockState.func_185899_b((IBlockAccess)fakeWorld, coordinate);
            }
            if (renderBlockState.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
                try {
                    dispatcher.func_175016_a(state, 1.0f);
                }
                catch (NullPointerException ex) {
                    BuildingGadgets.logger.error(ToolRenders.class.getSimpleName() + ": Error within overlay rendering -> " + ex);
                }
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.1f);
            dispatcher.func_175016_a(stainedGlassWhite, 1.0f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            Utils.stateManagerPrepare(playerPos, coordinate, Float.valueOf(0.002f));
            GlStateManager.func_179152_a((float)1.02f, (float)1.02f, (float)1.02f);
            GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.55f);
            hasEnergy = heldItem.hasCapability(CapabilityEnergy.ENERGY, null) ? (hasEnergy -= ModItems.gadgetExchanger.getEnergyCost(heldItem)) : (hasEnergy -= ModItems.gadgetExchanger.getDamageCost(heldItem));
            if (--hasBlocks < 0L || hasEnergy < 0) {
                dispatcher.func_175016_a(stainedGlassRed, 1.0f);
            }
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179112_b((int)770, (int)771);
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)MinecraftForgeClient.getRenderLayer());
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public static void renderDestructionOverlay(RenderWorldLastEvent evt, EntityPlayer player, ItemStack stack) {
        EnumFacing facing;
        RayTraceResult lookingAt = VectorTools.getLookingAt(player, stack);
        if (lookingAt == null && GadgetDestruction.getAnchor(stack) == null) {
            return;
        }
        World world = player.field_70170_p;
        BlockPos startBlock = GadgetDestruction.getAnchor(stack) == null ? lookingAt.func_178782_a() : GadgetDestruction.getAnchor(stack);
        EnumFacing enumFacing = facing = GadgetDestruction.getAnchorSide(stack) == null ? lookingAt.field_178784_b : GadgetDestruction.getAnchorSide(stack);
        if (startBlock == ModBlocks.effectBlock.func_176223_P()) {
            return;
        }
        if (!GadgetDestruction.getOverlay(stack)) {
            return;
        }
        GlStateManager.func_179094_E();
        double doubleX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)evt.getPartialTicks();
        double doubleY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)evt.getPartialTicks();
        double doubleZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)evt.getPartialTicks();
        GlStateManager.func_179137_b((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
        try {
            GlStateManager.func_179148_o((int)((Integer)cacheDestructionOverlay.get((Object)new ImmutableTriple((Object)new UniqueItemStack(stack), (Object)startBlock, (Object)facing.ordinal()), () -> {
                int displayList = GLAllocation.func_74526_a((int)1);
                GlStateManager.func_187423_f((int)displayList, (int)4864);
                ToolRenders.renderDestructionOverlay(player, world, startBlock, facing, stack);
                GlStateManager.func_187415_K();
                return displayList;
            })));
        }
        catch (ExecutionException e) {
            BuildingGadgets.logger.error("Error encountered while rendering destruction gadget overlay", (Throwable)e);
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    private static void renderDestructionOverlay(EntityPlayer player, World world, BlockPos startBlock, EnumFacing facing, ItemStack heldItem) {
        ToolRenders.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        SortedSet<BlockPos> coordinates = GadgetDestruction.getArea(world, startBlock, facing, player, heldItem);
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        List<BlockPos> sortedCoordinates = Sorter.Blocks.byDistance(coordinates, player);
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = t.func_178180_c();
        for (BlockPos coordinate : sortedCoordinates) {
            boolean invisible = true;
            IBlockState state = world.func_180495_p(coordinate);
            for (EnumFacing side : EnumFacing.values()) {
                if (!state.func_185894_c((IBlockAccess)world, coordinate, side)) continue;
                invisible = false;
                break;
            }
            if (invisible) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)coordinate.func_177958_n(), (float)coordinate.func_177956_o(), (float)coordinate.func_177952_p());
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)-0.005f, (float)-0.005f, (float)0.005f);
            GlStateManager.func_179152_a((float)1.01f, (float)1.01f, (float)1.01f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179090_x();
            ToolRenders.renderBoxSolid(t, bufferBuilder, 0.0, 0.0, -1.0, 1.0, 1.0, 0.0, 1.0f, 0.0f, 0.0f, 0.5f);
            GlStateManager.func_179098_w();
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179112_b((int)770, (int)771);
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)MinecraftForgeClient.getRenderLayer());
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public static void renderPasteOverlay(RenderWorldLastEvent evt, EntityPlayer player, ItemStack stack) {
        Vec3d playerPos = Utils.getPlayerTranslate(player, evt.getPartialTicks());
        ToolRenders.renderLinkedInventoryOutline(stack, playerPos, player);
        if (ModItems.gadgetCopyPaste.getStartPos(stack) == null || ModItems.gadgetCopyPaste.getEndPos(stack) == null) {
            return;
        }
        ToolRenders.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        String UUID = ModItems.gadgetCopyPaste.getUUID(stack);
        World world = player.field_70170_p;
        if (GadgetCopyPaste.getToolMode(stack) == GadgetCopyPaste.ToolMode.Paste) {
            BlockPos startPos = GadgetCopyPaste.getAnchor(stack);
            if (startPos == null) {
                startPos = VectorTools.getPosLookingAt(player, stack);
                if (startPos == null) {
                    return;
                }
                startPos = startPos.func_177981_b(GadgetCopyPaste.getY(stack));
                startPos = startPos.func_177965_g(GadgetCopyPaste.getX(stack));
                startPos = startPos.func_177970_e(GadgetCopyPaste.getZ(stack));
            } else {
                startPos = startPos.func_177981_b(GadgetCopyPaste.getY(stack));
                startPos = startPos.func_177965_g(GadgetCopyPaste.getX(stack));
                startPos = startPos.func_177970_e(GadgetCopyPaste.getZ(stack));
            }
            ToolDireBuffer toolDireBuffer = PasteToolBufferBuilder.getBufferFromMap(UUID);
            if (toolDireBuffer == null) {
                return;
            }
            List<BlockMap> blockMapList = GadgetCopyPaste.getBlockMapList(PasteToolBufferBuilder.getTagFromUUID(UUID));
            if (toolDireBuffer.func_178989_h() == 0 || blockMapList.size() == 0) {
                return;
            }
            IBlockState startBlock = world.func_180495_p(startPos);
            if (startBlock == ModBlocks.effectBlock.func_176223_P()) {
                return;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)32771, (int)32772);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)((double)startPos.func_177958_n() - playerPos.field_72450_a), (double)((double)startPos.func_177956_o() - playerPos.field_72448_b), (double)((double)startPos.func_177952_p() - playerPos.field_72449_c));
            GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.55f);
            GlStateManager.func_179109_b((float)5.0E-4f, (float)5.0E-4f, (float)-5.0E-4f);
            GlStateManager.func_179152_a((float)0.999f, (float)0.999f, (float)0.999f);
            PasteToolBufferBuilder.draw(player, playerPos.field_72450_a, playerPos.field_72448_b, playerPos.field_72449_c, startPos, UUID);
            GlStateManager.func_179121_F();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        } else {
            BlockPos startPos = ModItems.gadgetCopyPaste.getStartPos(stack);
            BlockPos endPos = ModItems.gadgetCopyPaste.getEndPos(stack);
            BlockPos blankPos = new BlockPos(0, 0, 0);
            if (startPos == null || endPos == null || startPos.equals((Object)blankPos) || endPos.equals((Object)blankPos)) {
                return;
            }
            List<BlockMap> blockMapList = GadgetCopyPaste.getBlockMapList(PasteToolBufferBuilder.getTagFromUUID(UUID));
            if (blockMapList.size() == 0) {
                return;
            }
            int x = startPos.func_177958_n() <= endPos.func_177958_n() ? startPos.func_177958_n() : endPos.func_177958_n();
            int y = startPos.func_177956_o() <= endPos.func_177956_o() ? startPos.func_177956_o() : endPos.func_177956_o();
            int z = startPos.func_177952_p() <= endPos.func_177952_p() ? startPos.func_177952_p() : endPos.func_177952_p();
            int dx = startPos.func_177958_n() > endPos.func_177958_n() ? startPos.func_177958_n() + 1 : endPos.func_177958_n() + 1;
            int dy = startPos.func_177956_o() > endPos.func_177956_o() ? startPos.func_177956_o() + 1 : endPos.func_177956_o() + 1;
            int dz = startPos.func_177952_p() > endPos.func_177952_p() ? startPos.func_177952_p() + 1 : endPos.func_177952_p() + 1;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(-playerPos.field_72450_a), (double)(-playerPos.field_72448_b), (double)(-playerPos.field_72449_c));
            GlStateManager.func_179140_f();
            GlStateManager.func_179090_x();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            ToolRenders.renderBox(tessellator, bufferbuilder, x, y, z, dx, dy, dz, 255, 223, 127);
            GlStateManager.func_187441_d((float)1.0f);
            GlStateManager.func_179145_e();
            GlStateManager.func_179098_w();
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179121_F();
        }
    }

    private static void renderLinkedInventoryOutline(ItemStack item, Vec3d playerPos, EntityPlayer player) {
        Integer dim = GadgetUtils.getDIMFromNBT(item, "boundTE");
        BlockPos pos = GadgetUtils.getPOSFromNBT(item, "boundTE");
        if (dim == null || pos == null) {
            return;
        }
        if (player.field_71093_bK != dim) {
            return;
        }
        GlStateManager.func_179094_E();
        Utils.stateManagerPrepare(playerPos, pos, Float.valueOf(5.0E-4f));
        Utils.stateManagerPrepareBlend();
        GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.35f);
        mc.func_175602_ab().func_175016_a(stainedGlassYellow, 1.0f);
        GlStateManager.func_179121_F();
    }

    private static void renderBox(Tessellator tessellator, BufferBuilder bufferBuilder, double startX, double startY, double startZ, double endX, double endY, double endZ, int R, int G, int B) {
        GlStateManager.func_187441_d((float)2.0f);
        bufferBuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        bufferBuilder.func_181662_b(startX, startY, startZ).func_181666_a((float)G, (float)G, (float)G, 0.0f).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, startZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, startZ).func_181669_b(G, B, B, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, startZ).func_181669_b(B, B, G, R).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, startZ).func_181669_b(B, G, B, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, startZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, startZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, startZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, startZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, startZ).func_181666_a((float)G, (float)G, (float)G, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_187441_d((float)1.0f);
    }

    private static void renderBoxSolid(Tessellator tessellator, BufferBuilder bufferBuilder, double startX, double startY, double startZ, double endX, double endY, double endZ, float red, float green, float blue, float alpha) {
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferBuilder.func_181662_b(startX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
    }

    private static class Utils {
        private Utils() {
        }

        private static IBlockState getStartBlock(RayTraceResult lookingAt, EntityPlayer player) {
            IBlockState startBlock = Blocks.field_150350_a.func_176223_P();
            if (lookingAt != null) {
                startBlock = player.field_70170_p.func_180495_p(lookingAt.func_178782_a());
            }
            return startBlock;
        }

        private static int getStackEnergy(ItemStack stack, EntityPlayer player) {
            if (player.field_71075_bZ.field_75098_d || !stack.hasCapability(CapabilityEnergy.ENERGY, null) && !stack.func_77984_f()) {
                return Integer.MAX_VALUE;
            }
            if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
                return CapabilityProviderEnergy.getCap(stack).getEnergyStored();
            }
            return stack.func_77958_k() - stack.func_77952_i();
        }

        private static Vec3d getPlayerTranslate(EntityPlayer player, float partialTick) {
            return new Vec3d(player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTick, player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTick, player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTick);
        }

        private static ItemStack getSilkDropIfPresent(World world, IBlockState state, EntityPlayer player) {
            ItemStack itemStack = ItemStack.field_190927_a;
            if (state.func_177230_c().canSilkHarvest(world, BlockPos.field_177992_a, state, player)) {
                itemStack = InventoryManipulation.getSilkTouchDrop(state);
            }
            if (itemStack.func_190926_b()) {
                itemStack = state.func_177230_c().getPickBlock(state, null, world, BlockPos.field_177992_a, player);
            }
            return itemStack;
        }

        private static void stateManagerPrepareBlend() {
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)32771, (int)32772);
        }

        private static void stateManagerPrepare(Vec3d playerPos, BlockPos blockPos, Float shift) {
            GlStateManager.func_179137_b((double)((double)blockPos.func_177958_n() - playerPos.field_72450_a), (double)((double)blockPos.func_177956_o() - playerPos.field_72448_b), (double)((double)blockPos.func_177952_p() - playerPos.field_72449_c));
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
            if (shift != null) {
                GlStateManager.func_179109_b((float)(-shift.floatValue()), (float)(-shift.floatValue()), (float)shift.floatValue());
                GlStateManager.func_179152_a((float)1.005f, (float)1.005f, (float)1.005f);
            }
        }
    }
}

