/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.skygrid.handlers;

import funwayguy.skygrid.config.GridBlock;
import funwayguy.skygrid.config.GridRegistry;
import funwayguy.skygrid.core.SG_Settings;
import funwayguy.skygrid.core.SkyGrid;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import org.apache.logging.log4j.Level;

public class ConfigHandler {
    public static Configuration config;

    public static void initConfigs() {
        Block b;
        String[] tmp;
        if (config == null) {
            SkyGrid.logger.log(Level.ERROR, "Config attempted to be loaded before it was initialised!");
            return;
        }
        config.load();
        SG_Settings.height = config.getInt("Grid Height", "general", 128, 1, 255, "How high should the grid of blocks be");
        SG_Settings.dist = config.getInt("Grid Spacing", "general", 3, 0, 15, "How much open space should there be between blocks") + 1;
        SG_Settings.populate = config.getBoolean("Natural Populate", "general", false, "Naturally populate the grid with trees and plants");
        SG_Settings.rngSpacing = config.getBoolean("Random Spacing", "general", false, "Randomise the spacing between 1 and the configured value (per chunk)");
        SG_Settings.oldRegen = config.getBoolean("Old Regen", "client", true, "Use the old health regen speed at full hunger (easier to navigate grids)");
        SG_Settings.spawnFix = config.getBoolean("Mob Spawn Fix", "general", true, "Pre-emptively cancels spawn attempts over the void. May prevent some flying mobs spawning");
        SG_Settings.lightFix = config.getBoolean("Lighting Fix", "general", true, "Disables relighting checks to prevent framerate dips on chunk generation");
        SG_Settings.spawnO = new ArrayList<String>();
        SG_Settings.spawnO.addAll(Arrays.asList(config.getStringList("Spawners Overworld", "general", new String[]{"minecraft:skeleton", "minecraft:zombie", "minecraft:spider", "minecraft:cave_spider"}, "Sets the possible spawner types in the grid")));
        SG_Settings.spawnN = new ArrayList<String>();
        SG_Settings.spawnN.addAll(Arrays.asList(config.getStringList("Spawners Nether", "general", new String[]{"minecraft:blaze", "minecraft:zombie_pigman", "minecraft:magma_cube"}, "Sets the possible spawner types in the grid")));
        SG_Settings.spawnE = new ArrayList<String>();
        SG_Settings.spawnE.addAll(Arrays.asList(config.getStringList("Spawners End", "general", new String[]{"minecraft:enderman", "endermite"}, "Sets the possible spawner types in the grid")));
        if (Loader.isModLoaded((String)"abyssalcraft")) {
            SG_Settings.spawnAW = new ArrayList<String>();
            SG_Settings.spawnAW.addAll(Arrays.asList(config.getStringList("Spawners Abyssal Wasteland", "general", new String[]{"abyssalcraft:depthsghoul", "abyssalcraft:abyssalzombie", "abyssalcraft:gskeleton", "abyssalcraft:lessershoggoth"}, "Sets ths possible spawner types in the grid")));
            SG_Settings.spawnDL = new ArrayList<String>();
            SG_Settings.spawnDL.addAll(Arrays.asList(config.getStringList("Spawners Dreadlands", "general", new String[]{"abyssalcraft:dreadspawn", "abyssalcraft:lessershoggoth"}, "Sets ths possible spawner types in the grid")));
            SG_Settings.spawnOMT = new ArrayList<String>();
            SG_Settings.spawnOMT.addAll(Arrays.asList(config.getStringList("Spawners Omothol", "general", new String[]{"abyssalcraft:remnant", "abyssalcraft:jzaharminion", "abyssalcraft:omotholghoul", "abyssalcraft:lessershoggoth"}, "Sets ths possible spawner types in the grid")));
            SG_Settings.spawnDR = new ArrayList<String>();
            SG_Settings.spawnDR.addAll(Arrays.asList(config.getStringList("Spawners Dark Realm", "general", new String[]{"abyssalcraft:shadowcreature", "abyssalcraft:shadowmonster", "abyssalcraft:shadowbeast", "abyssalcraft:lessershoggoth"}, "Sets ths possible spawner types in the grid")));
        }
        if (config.getCategory("general").containsKey("Overworld Grid Blocks")) {
            tmp = config.getStringList("Overworld Grid Blocks", "general", new String[0], "Which blocks should be present in the grid");
            GridRegistry.blocksOverworld.clear();
            for (String s : tmp) {
                b = Block.func_149684_b((String)s);
                if (b == null) continue;
                GridRegistry.blocksOverworld.add(new GridBlock(b));
            }
            config.getCategory("general").remove((Object)"Overworld Grid Blocks");
        }
        if (config.getCategory("general").containsKey("Nether Grid Blocks")) {
            tmp = config.getStringList("Nether Grid Blocks", "general", new String[0], "Which blocks should be present in the grid");
            GridRegistry.blocksNether.clear();
            for (String s : tmp) {
                b = Block.func_149684_b((String)s);
                if (b == null) continue;
                GridRegistry.blocksNether.add(new GridBlock(b));
            }
            config.getCategory("general").remove((Object)"Nether Grid Blocks");
        }
        if (config.getCategory("general").containsKey("Crops")) {
            config.getCategory("general").remove((Object)"Crops");
        }
        config.save();
        SkyGrid.logger.log(Level.INFO, "Loaded configs...");
    }
}

