/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.skygrid.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import funwayguy.skygrid.core.SkyGrid;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.Level;

public class JsonHelper {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static JsonArray GetArray(JsonObject json, String id) {
        if (json == null) {
            return new JsonArray();
        }
        if (json.has(id) && json.get(id).isJsonArray()) {
            return json.get(id).getAsJsonArray();
        }
        JsonArray array = new JsonArray();
        json.add(id, (JsonElement)array);
        return array;
    }

    public static JsonObject GetObject(JsonObject json, String id) {
        if (json == null) {
            return new JsonObject();
        }
        if (json.has(id) && json.get(id).isJsonObject()) {
            return json.get(id).getAsJsonObject();
        }
        JsonObject obj = new JsonObject();
        json.add(id, (JsonElement)obj);
        return obj;
    }

    public static String GetString(JsonObject json, String id, String def) {
        if (json == null) {
            return def;
        }
        if (json.has(id) && json.get(id).isJsonPrimitive() && json.get(id).getAsJsonPrimitive().isString()) {
            return json.get(id).getAsString();
        }
        JsonPrimitive prim = new JsonPrimitive(def);
        json.add(id, (JsonElement)prim);
        return def;
    }

    public static Number GetNumber(JsonObject json, String id, Number def) {
        if (json == null) {
            return def;
        }
        if (json.has(id) && json.get(id).isJsonPrimitive() && json.get(id).getAsJsonPrimitive().isNumber()) {
            return json.get(id).getAsInt();
        }
        JsonPrimitive prim = new JsonPrimitive(def);
        json.add(id, (JsonElement)prim);
        return def;
    }

    public static boolean GetBoolean(JsonObject json, String id, boolean def) {
        if (json == null) {
            return def;
        }
        if (json.has(id) && json.get(id).isJsonPrimitive()) {
            try {
                return json.get(id).getAsBoolean();
            }
            catch (Exception e) {
                JsonPrimitive prim = new JsonPrimitive(Boolean.valueOf(def));
                json.add(id, (JsonElement)prim);
                return def;
            }
        }
        JsonPrimitive prim = new JsonPrimitive(Boolean.valueOf(def));
        json.add(id, (JsonElement)prim);
        return def;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonObject ReadObjectFromFile(File file) {
        if (file == null) return new JsonObject();
        if (!file.exists()) {
            return new JsonObject();
        }
        try (InputStreamReader fr = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)fr, JsonObject.class);
            return jsonObject;
        }
        catch (Exception e) {
            SkyGrid.logger.log(Level.ERROR, "An error occured while loading JSON from file:", (Throwable)e);
            return new JsonObject();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonArray ReadArrayFromFile(File file) {
        if (file == null) return new JsonArray();
        if (!file.exists()) {
            return new JsonArray();
        }
        try (InputStreamReader fr = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            JsonArray jsonArray = (JsonArray)GSON.fromJson((Reader)fr, JsonArray.class);
            return jsonArray;
        }
        catch (Exception e) {
            SkyGrid.logger.log(Level.ERROR, "An error occured while loading JSON from file:", (Throwable)e);
            return new JsonArray();
        }
    }

    public static void WriteToFile(File file, JsonElement json) {
        try {
            if (!file.exists()) {
                if (file.getParentFile() != null) {
                    file.getParentFile().mkdirs();
                }
                if (!file.createNewFile()) {
                    throw new FileNotFoundException("Unable to create file " + file.getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            SkyGrid.logger.log(Level.ERROR, "An error occured while saving JSON to file:", (Throwable)e);
            return;
        }
        try (OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            GSON.toJson(json, (Appendable)fw);
            fw.flush();
        }
        catch (Exception e) {
            SkyGrid.logger.log(Level.ERROR, "An error occured while saving JSON to file:", (Throwable)e);
        }
    }
}

