/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.skygrid.world;

import funwayguy.skygrid.compat.abyssalcraft.SGACPlugin;
import funwayguy.skygrid.core.SG_Settings;
import funwayguy.skygrid.util.CustomLootTableManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;

public class PostGenerator
implements IWorldGenerator {
    public static HashMap<String, ArrayList<BlockPos>> tileLoc = new HashMap();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        String key = world.field_73011_w.getDimension() + ":" + chunkX + ":" + chunkZ;
        ArrayList<BlockPos> list = tileLoc.get(key);
        if (list == null) {
            return;
        }
        for (BlockPos pos : list) {
            List<String> entities;
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntityLockableLoot) {
                TileEntityLockableLoot invo = (TileEntityLockableLoot)tile;
                ResourceLocation lootRes = CustomLootTableManager.getTable(world, pos, random);
                invo.func_189404_a(lootRes, random.nextLong());
                continue;
            }
            if (!(tile instanceof TileEntityMobSpawner)) continue;
            TileEntityMobSpawner spawner = (TileEntityMobSpawner)tile;
            switch (world.field_73011_w.getDimension()) {
                case -1: {
                    entities = SG_Settings.spawnN;
                    break;
                }
                case 1: {
                    entities = SG_Settings.spawnE;
                    break;
                }
                default: {
                    entities = Loader.isModLoaded((String)"abyssalcraft") ? SGACPlugin.assignList(world.field_73011_w.getDimension()) : SG_Settings.spawnO;
                }
            }
            if (entities.size() <= 0) continue;
            spawner.func_145881_a().func_190894_a(new ResourceLocation(entities.get(random.nextInt(entities.size()))));
        }
        list.clear();
        if (world.field_73011_w.getDimension() == 1 && chunkX == 0 && chunkZ == 0) {
            EntityDragon dragon = new EntityDragon(world);
            dragon.func_70107_b(0.0, (double)(SG_Settings.height + 16), 0.0);
            world.func_72838_d((Entity)dragon);
        }
    }

    public static void addLocation(int dimension, int chunkX, int chunkZ, BlockPos pos) {
        String key = dimension + ":" + chunkX + ":" + chunkZ;
        ArrayList<BlockPos> list = tileLoc.get(key);
        ArrayList<BlockPos> arrayList = list = list != null ? list : new ArrayList<BlockPos>();
        if (!list.contains(pos)) {
            list.add(pos);
            tileLoc.put(key, list);
        }
    }

    public static void resetLocations() {
        tileLoc.clear();
    }
}

