/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.dynamo;

import cofh.core.inventory.ComparableItemStack;
import cofh.core.util.helpers.EnergyHelper;
import cofh.redstoneflux.api.IEnergyContainerItem;
import com.google.common.collect.ImmutableSet;
import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;

public class EnervationManager {
    private static TObjectIntHashMap<ComparableItemStack> fuelMap = new TObjectIntHashMap();
    public static int DEFAULT_ENERGY = 64000;
    public static final int ENCHANT_ENERGY = 5000;

    public static Set<ComparableItemStack> getFuels() {
        return ImmutableSet.copyOf((Collection)fuelMap.keySet());
    }

    public static int getEnchantEnergy(ItemStack stack) {
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)stack);
        int enchantRF = 0;
        for (Enchantment enchant : enchants.keySet()) {
            enchantRF += enchant.func_77321_a(((Integer)enchants.get(enchant)).intValue());
        }
        enchantRF += enchants.size() * (enchants.size() + 1) / 2;
        return enchantRF *= 5000;
    }

    public static int getFuelEnergy(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        int energy = fuelMap.get((Object)new ComparableItemStack(stack));
        if (energy > 0) {
            return energy;
        }
        if (EnergyHelper.isEnergyContainerItem((ItemStack)stack)) {
            IEnergyContainerItem container = (IEnergyContainerItem)stack.func_77973_b();
            return container.extractEnergy(stack, container.getEnergyStored(stack), true);
        }
        return 0;
    }

    public static void refresh() {
        TObjectIntHashMap tempMap = new TObjectIntHashMap(fuelMap.size());
        TObjectIntIterator it = fuelMap.iterator();
        while (it.hasNext()) {
            it.advance();
            tempMap.put((Object)new ComparableItemStack(((ComparableItemStack)it.key()).toItemStack()), it.value());
        }
        fuelMap.clear();
        fuelMap = tempMap;
    }

    public static boolean addFuel(ItemStack stack, int energy) {
        if (stack.func_190926_b() || energy < 2000 || energy > 200000000) {
            return false;
        }
        if (fuelMap.containsKey((Object)new ComparableItemStack(stack))) {
            return false;
        }
        fuelMap.put((Object)new ComparableItemStack(stack), energy);
        return true;
    }

    public static boolean removeFuel(ItemStack stack) {
        fuelMap.remove((Object)new ComparableItemStack(stack));
        return true;
    }
}

