/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.tileentity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import omtteam.omlib.api.network.INetworkCable;
import omtteam.omlib.api.network.INetworkTile;
import omtteam.omlib.api.network.OMLibNetwork;
import omtteam.omlib.api.permission.IHasOwner;
import omtteam.omlib.api.tile.IDebugTile;
import omtteam.omlib.tileentity.TileEntityBase;
import omtteam.omlib.util.player.Player;

public class TileEntityCable
extends TileEntityBase
implements INetworkCable,
IDebugTile,
IHasOwner {
    private Map<EnumFacing, Boolean> facingMap = new HashMap<EnumFacing, Boolean>();
    private OMLibNetwork network;

    public TileEntityCable() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.facingMap.put(facing, false);
        }
    }

    @Override
    public boolean shouldConnect(EnumFacing side) {
        return this.facingMap.get(side);
    }

    @Override
    public OMLibNetwork getNetwork() {
        return this.network;
    }

    @Override
    public void setNetwork(OMLibNetwork network) {
        this.network = network;
    }

    @Override
    @Nonnull
    public String getDeviceName() {
        return "networkCable";
    }

    @Override
    @Nonnull
    public BlockPos getPosition() {
        return this.func_174877_v();
    }

    @Override
    public List<String> getDebugInfo() {
        ArrayList<String> debug = new ArrayList<String>();
        debug.add("Network = " + this.getNetwork().getUuid().toString());
        return debug;
    }

    private void refreshFacingMap() {
        this.facingMap = new HashMap<EnumFacing, Boolean>();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(facing)) instanceof INetworkTile) {
                this.facingMap.put(facing, true);
                continue;
            }
            this.facingMap.put(facing, false);
        }
    }

    public void onLoad() {
        super.onLoad();
        this.refreshFacingMap();
        if (this.network == null) {
            this.scan(this.func_145831_w(), this.func_174877_v(), "");
        }
    }

    @Override
    @Nonnull
    public Player getOwner() {
        return this.network.getOwner();
    }
}

