/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.alchemy.item;

import com.bartz24.skyresources.base.MachineVariants;
import com.bartz24.skyresources.base.gui.GuiCasing;
import com.bartz24.skyresources.base.gui.SlotSpecial;
import com.bartz24.skyresources.base.item.ItemMachine;
import com.bartz24.skyresources.base.tile.TileCasing;
import com.bartz24.skyresources.events.ClientEventHandler;
import com.bartz24.skyresources.recipe.ProcessRecipe;
import com.bartz24.skyresources.recipe.ProcessRecipeManager;
import com.bartz24.skyresources.registry.ModCreativeTabs;
import java.awt.Color;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ItemCondenser
extends ItemMachine {
    public ItemCondenser() {
        super("condenser", ModCreativeTabs.tabAlchemy, false, false, true, true);
    }

    @Override
    public void update(World world, BlockPos pos, ItemStack machineStack, NBTTagCompound data) {
        this.condense(world, pos, machineStack, data);
        if (!world.field_72995_K) {
            BlockPos[] poses;
            for (BlockPos posAdj : poses = new BlockPos[]{pos.func_177974_f(), pos.func_177976_e(), pos.func_177968_d(), pos.func_177978_c()}) {
                if (!(world.func_180495_p(posAdj).func_177230_c() instanceof BlockFluidBase) || (Integer)world.func_180495_p(posAdj).func_177229_b((IProperty)BlockFluidBase.LEVEL) <= 0) continue;
                world.func_175698_g(posAdj);
            }
        }
    }

    void condense(World world, BlockPos pos, ItemStack machineStack, NBTTagCompound data) {
        int timeCondense = data.func_74762_e("time");
        float itemLeft = data.func_74760_g("left");
        ItemStack itemUsing = new ItemStack(data.func_74775_l("itemUsing"));
        Random rand = world.field_73012_v;
        Block block = this.getBlockAbove(world, pos);
        if (this.getCasingTile(world, pos).getRedstoneSignal() == 0 && block != Blocks.field_150350_a) {
            ItemStack stack;
            BlockFluidBase fluidBlock;
            FluidStack blockIn = null;
            if (block instanceof BlockFluidBase) {
                fluidBlock = (BlockFluidBase)block;
                if (fluidBlock.func_176201_c(world.func_180495_p(pos.func_177984_a())) == 0) {
                    blockIn = new FluidStack(fluidBlock.getFluid(), 1000);
                }
            } else if (block instanceof IFluidBlock) {
                fluidBlock = (IFluidBlock)block;
                blockIn = new FluidStack(fluidBlock.getFluid(), 1000);
            } else {
                blockIn = new ItemStack(block, 1, block.func_176201_c(world.func_180495_p(pos.func_177984_a())));
            }
            ItemStack dust = itemLeft > 0.0f ? itemUsing : this.getCasingTile(world, pos).getInventory().getStackInSlot(0);
            ProcessRecipe recipe = null;
            if (blockIn != null) {
                recipe = ProcessRecipeManager.condenserRecipes.getRecipe(Arrays.asList(dust, blockIn), 2.1474836E9f, false, false);
            }
            if (recipe != null) {
                if (timeCondense < this.getTimeToCondense(world, pos, machineStack, recipe)) {
                    if (itemLeft <= 0.0f && !world.field_72995_K) {
                        itemLeft = 1.0f;
                        if (!itemUsing.func_77969_a(this.getCasingTile(world, pos).getInventory().getStackInSlot(0))) {
                            timeCondense = 0;
                        }
                        itemUsing = this.getCasingTile(world, pos).getInventory().getStackInSlot(0).func_77946_l();
                        itemUsing.func_190920_e(1);
                        this.getCasingTile(world, pos).getInventory().getStackInSlot(0).func_190918_g(1);
                    }
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)pos.func_177956_o() + 1.5, (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
                    if (!world.field_72995_K) {
                        ++timeCondense;
                        itemLeft = (float)((double)itemLeft - Math.pow(recipe.getIntParameter(), 1.3f) / 50.0 / (double)(2400.0f * recipe.getIntParameter() / 50.0f * this.getMachineEfficiency(machineStack, world, pos)));
                    }
                }
            } else if (!world.field_72995_K) {
                timeCondense = 0;
            }
            boolean sound = false;
            if (recipe != null && timeCondense >= this.getTimeToCondense(world, pos, machineStack, recipe) && !world.field_72995_K && this.ejectResultSlot(stack = recipe.getOutputs().get(0).func_77946_l(), world, pos, true)) {
                sound = true;
                world.func_175698_g(pos.func_177982_a(0, 1, 0));
                this.ejectResultSlot(stack, world, pos, false);
                timeCondense = 0;
            }
            if (sound && (double)MachineVariants.values()[world.func_180495_p(pos).func_177230_c().func_176201_c(world.func_180495_p(pos))].getRawSpeed() < 2.0) {
                world.func_184133_a(null, pos, SoundEvents.field_187734_u, SoundCategory.BLOCKS, 1.0f, 2.2f / (rand.nextFloat() * 0.2f + 0.9f));
            }
        }
        data.func_74768_a("time", timeCondense);
        data.func_74776_a("left", itemLeft);
        data.func_74782_a("itemUsing", (NBTBase)itemUsing.func_77955_b(new NBTTagCompound()));
    }

    boolean ejectResultSlot(ItemStack output, World world, BlockPos pos, boolean sim) {
        if (!world.field_72995_K) {
            ItemStack out = output.func_77946_l();
            BlockPos facingPos = pos.func_177977_b();
            TileEntity tile = world.func_175625_s(facingPos);
            if (tile != null) {
                if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) {
                    return ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)), (ItemStack)out, (boolean)sim).func_190926_b();
                }
                if (tile instanceof IInventory) {
                    return ItemHandlerHelper.insertItemStacked((IItemHandler)new InvWrapper((IInventory)tile), (ItemStack)out, (boolean)sim).func_190926_b();
                }
                return false;
            }
            if (!sim && out != ItemStack.field_190927_a && out.func_190916_E() > 0) {
                EntityItem item = new EntityItem(world, (double)((float)pos.func_177977_b().func_177958_n() + 0.5f), (double)((float)pos.func_177977_b().func_177956_o() + 0.5f), (double)((float)pos.func_177977_b().func_177952_p() + 0.5f), out.func_77946_l());
                item.field_70181_x = 0.0;
                item.field_70159_w = 0.0;
                item.field_70179_y = 0.0;
                world.func_72838_d((Entity)item);
            }
        }
        return true;
    }

    public int getTimeToCondense(World world, BlockPos pos, ItemStack machineStack, ProcessRecipe recipe) {
        return Math.round(recipe.getIntParameter() / this.getMachineSpeed(machineStack, world, pos));
    }

    public Block getBlockAbove(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177982_a(0, 1, 0)).func_177230_c();
    }

    @Override
    public int getItemSlots(ItemStack stack) {
        return 1;
    }

    @Override
    public int[] getExtractBlacklist(ItemStack stack) {
        return new int[]{0};
    }

    @Override
    public List<Slot> getSlots(TileCasing tile) {
        return Collections.singletonList(new SlotSpecial((IItemHandler)tile.getInventory(), 0, 80, 53));
    }

    @Override
    public void initGui(GuiCasing gui, List buttonList) {
        ClientEventHandler.initGui(gui, buttonList);
    }

    @Override
    public void actionPerformed(TileCasing tile, GuiCasing gui, int buttonClicked) throws IOException {
        ClientEventHandler.actionPerformed(0, tile, gui, buttonClicked);
    }

    @Override
    public void drawBackgroundGui(TileCasing tile, GuiCasing gui, FontRenderer fontRenderer, int mouseX, int mouseY) {
        super.drawBackgroundGui(tile, gui, fontRenderer, mouseX, mouseY);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("skyresources", "textures/gui/blankInventory.png"));
        gui.func_73729_b(gui.getGuiLeft() + 79, gui.getGuiTop() + 52, 7, 83, 18, 18);
    }

    @Override
    public void drawForegroundGui(TileCasing tile, GuiCasing gui, FontRenderer fontRenderer, int mouseX, int mouseY) {
        FluidStack blockIn;
        int timeCondense = tile.machineData.func_74762_e("time");
        float itemLeft = tile.machineData.func_74760_g("left");
        ItemStack itemUsing = new ItemStack(tile.machineData.func_74775_l("itemUsing"));
        Block block = this.getBlockAbove(tile.func_145831_w(), tile.func_174877_v());
        if (block instanceof IFluidBlock) {
            IFluidBlock fluidBlock = (IFluidBlock)block;
            blockIn = new FluidStack(fluidBlock.getFluid(), 1000);
        } else {
            blockIn = new ItemStack(block, 1, block.func_176201_c(tile.func_145831_w().func_180495_p(tile.func_174877_v().func_177984_a())));
        }
        ItemStack dust = itemLeft > 0.0f ? itemUsing : tile.getInventory().getStackInSlot(0);
        ProcessRecipe recipe = ProcessRecipeManager.condenserRecipes.getRecipe(Arrays.asList(dust, blockIn), 2.1474836E9f, false, false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("skyresources", "textures/gui/guiicons.png"));
        gui.func_73729_b(100, 52, 29, 60, 3, 18);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("skyresources", "textures/gui/guiicons.png"));
        gui.func_73729_b(101, 69 - (int)(16.0f * itemLeft), 26, 77 - (int)(16.0f * itemLeft), 1, (int)(16.0f * itemLeft));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("skyresources", "textures/gui/guiicons.png"));
        gui.func_73729_b(80, 27, 18, 80, 16, 24);
        if (recipe != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("skyresources", "textures/gui/guiicons.png"));
            gui.func_73729_b(80, 51 - (int)((float)timeCondense / (float)this.getTimeToCondense(tile.func_145831_w(), tile.func_174877_v(), tile.machineStored, recipe) * 24.0f), 1, 104 - (int)((float)timeCondense / (float)this.getTimeToCondense(tile.func_145831_w(), tile.func_174877_v(), tile.machineStored, recipe) * 24.0f), 16, (int)((float)timeCondense / (float)this.getTimeToCondense(tile.func_145831_w(), tile.func_174877_v(), tile.machineStored, recipe) * 24.0f));
            double dustPerTick = Math.pow(recipe.getIntParameter(), 1.3f) / 50.0 / (double)(2400.0f * recipe.getIntParameter() / 50.0f);
            String s = (float)Math.round(1.0 / dustPerTick / (double)recipe.getIntParameter() * (double)itemLeft * (double)this.getMachineSpeed(tile.machineStored, tile.func_145831_w(), tile.func_174877_v()) * (double)this.getMachineEfficiency(tile.machineStored, tile.func_145831_w(), tile.func_174877_v()) * 10000.0) / 10000.0f + "";
            fontRenderer.func_78276_b(s, 28, 51, Color.GRAY.getRGB());
            fontRenderer.func_78276_b("Expected from", 6, 24, Color.GRAY.getRGB());
            fontRenderer.func_78276_b("remaining input", 6, 34, Color.GRAY.getRGB());
            ItemStack stack = recipe.getOutputs().get(0).func_77946_l();
            stack.func_190920_e(1);
            RenderHelper.func_74520_c();
            gui.getItemRender().func_180450_b(stack, 10, 47);
            RenderHelper.func_74518_a();
        }
        super.drawForegroundGui(tile, gui, fontRenderer, mouseX, mouseY);
    }
}

