/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.alchemy.item;

import com.bartz24.skyresources.ItemHelper;
import com.bartz24.skyresources.config.ConfigOptions;
import com.bartz24.skyresources.recipe.ProcessRecipe;
import com.bartz24.skyresources.recipe.ProcessRecipeManager;
import com.bartz24.skyresources.registry.ModCreativeTabs;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class ItemInfusionStone
extends Item {
    public ItemInfusionStone(int durability, String unlocalizedName, String registryName) {
        this.func_77656_e((int)((double)durability * ConfigOptions.toolSettings.infusionStoneBaseDurability));
        this.func_77655_b("skyresources." + unlocalizedName);
        this.setRegistryName(registryName);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77637_a(ModCreativeTabs.tabAlchemy);
        ItemHelper.addInfusionStone(this);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        super.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
        ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
        Block block = world.func_180495_p(pos).func_177230_c();
        ItemStack offHand = player.func_184592_cb();
        ProcessRecipe recipe = ProcessRecipeManager.infusionRecipes.getRecipe(new ArrayList<ItemStack>(Arrays.asList(offHand, new ItemStack(block, 1, block.func_176201_c(world.func_180495_p(pos))))), player.func_110143_aJ(), false, false);
        if (recipe != null && recipe.getOutputs().get(0) != ItemStack.field_190927_a) {
            if (player.func_110138_aP() < recipe.getIntParameter() && world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString("You are not strong enough to infuse. Your max health is too low."));
            }
            if (player.func_110143_aJ() >= recipe.getIntParameter()) {
                if (!world.field_72995_K) {
                    player.func_71019_a(recipe.getOutputs().get(0).func_77946_l(), false);
                    if (offHand != ItemStack.field_190927_a) {
                        offHand.func_190918_g(recipe.getInputs().get(0) instanceof ItemStack ? ((ItemStack)recipe.getInputs().get(0)).func_190916_E() : 1);
                    }
                    stack.func_77972_a(1, (EntityLivingBase)player);
                    player.func_70097_a(DamageSource.field_76376_m, recipe.getIntParameter());
                }
                world.func_175698_g(pos);
            } else if (world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString("Not enough health to infuse."));
            }
        }
        if (recipe == null && ItemInfusionStone.applyBonemeal(stack, world, pos, player)) {
            if (!world.field_72995_K) {
                world.func_175718_b(2005, pos, 0);
            }
            return EnumActionResult.SUCCESS;
        }
        if (world.field_72995_K) {
            player.func_184609_a(EnumHand.MAIN_HAND);
        }
        return EnumActionResult.PASS;
    }

    public static boolean applyBonemeal(ItemStack stack, World worldIn, BlockPos target, EntityPlayer player) {
        if (ConfigOptions.toolSettings.infusionStoneBonemealCapability && worldIn.func_180495_p(target).func_177230_c() instanceof IGrowable && !worldIn.field_72995_K) {
            for (int tries = 100; worldIn.func_180495_p(target).func_177230_c() instanceof IGrowable && tries > 0; --tries) {
                IGrowable igrowable = (IGrowable)worldIn.func_180495_p(target).func_177230_c();
                if (!igrowable.func_176473_a(worldIn, target, worldIn.func_180495_p(target), false)) continue;
                igrowable.func_176474_b(worldIn, worldIn.field_73012_v, target, worldIn.func_180495_p(target));
            }
            stack.func_77972_a(1, (EntityLivingBase)player);
            player.func_70097_a(DamageSource.field_76376_m, 4.0f);
            return true;
        }
        return false;
    }
}

