/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.alchemy.render;

import com.bartz24.skyresources.RandomHelper;
import com.bartz24.skyresources.alchemy.tile.CrucibleTile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class CrucibleTESR
extends TileEntitySpecialRenderer<CrucibleTile> {
    public void render(CrucibleTile te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glPopMatrix();
        if (te.getTank().getFluid() != null && te.getTank().getFluidAmount() > 0) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            this.renderFluidContents(te, x, y, z);
            GL11.glPopMatrix();
        }
    }

    private void renderFluidContents(CrucibleTile crucible, double x, double y, double z) {
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FluidStack fluidStack = crucible.getTank().getFluid();
        Fluid fluid = fluidStack.getFluid();
        ResourceLocation textureRL = fluid.getStill();
        TextureAtlasSprite texture = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174952_b().func_110572_b(textureRL.func_110624_b() + ":" + textureRL.func_110623_a());
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        if (texture != null) {
            int color = fluid.getColor(fluidStack);
        } else {
            int color = -1;
        }
        double liquid = crucible.getTank().getFluidAmount();
        double maxLiquid = crucible.getTank().getCapacity();
        double height = liquid / maxLiquid * 0.7;
        GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
        RandomHelper.renderFluidCuboid(fluidStack, crucible.func_174877_v(), 0.0, -0.85, -1.0, 0.1, 0.2, 0.1, 0.9, 0.1 + height, 0.9);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
    }
}

