/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.alchemy.tile;

import com.bartz24.skyresources.alchemy.item.ItemHealthGem;
import com.bartz24.skyresources.base.gui.ItemHandlerSpecial;
import com.bartz24.skyresources.base.tile.TileItemInventory;
import com.bartz24.skyresources.recipe.ProcessRecipe;
import com.bartz24.skyresources.recipe.ProcessRecipeManager;
import com.bartz24.skyresources.registry.ModBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.oredict.OreDictionary;

public class LifeInfuserTile
extends TileItemInventory
implements ITickable {
    private static final Map<String, List<ItemStack>> oreMap = new HashMap<String, List<ItemStack>>();

    public LifeInfuserTile() {
        super("lifeInfuser", 2, null, new int[]{1});
        this.setInventory(new ItemHandlerSpecial(3, null, new int[]{1}){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                LifeInfuserTile.this.func_70296_d();
            }

            @Override
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (slot == 0 && !(stack.func_77973_b() instanceof ItemHealthGem)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        });
    }

    public void func_73660_a() {
        if (this.receivedPulse() && this.hasValidMultiblock()) {
            this.craftItem();
        }
    }

    public boolean hasValidMultiblock() {
        BlockPos[] pillarPoses;
        for (BlockPos pos : pillarPoses = new BlockPos[]{this.field_174879_c.func_177978_c().func_177976_e(), this.field_174879_c.func_177978_c().func_177974_f(), this.field_174879_c.func_177968_d().func_177976_e(), this.field_174879_c.func_177968_d().func_177974_f()}) {
            ItemStack stack = new ItemStack(this.field_145850_b.func_180495_p(pos).func_177230_c(), 1, this.field_145850_b.func_180495_p(pos).func_177230_c().func_180651_a(this.field_145850_b.func_180495_p(pos)));
            if (!this.isOreDict(stack, "logWood")) {
                return false;
            }
            stack = new ItemStack(this.field_145850_b.func_180495_p(pos.func_177977_b()).func_177230_c(), 1, this.field_145850_b.func_180495_p(pos.func_177977_b()).func_177230_c().func_180651_a(this.field_145850_b.func_180495_p(pos.func_177977_b())));
            if (this.isOreDict(stack, "logWood")) continue;
            return false;
        }
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                BlockPos posCheck = new BlockPos(x, 0, z).func_177971_a((Vec3i)this.field_174879_c);
                ItemStack stack = new ItemStack(this.field_145850_b.func_180495_p(posCheck.func_177984_a()).func_177230_c(), 1, this.field_145850_b.func_180495_p(posCheck.func_177984_a()).func_177230_c().func_180651_a(this.field_145850_b.func_180495_p(posCheck.func_177984_a())));
                if (!(x == 0 && z == 0 ? this.field_145850_b.func_180495_p(posCheck.func_177984_a()).func_177230_c() != ModBlocks.darkMatterBlock : !this.isOreDict(stack, "treeLeaves"))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isOreDict(ItemStack stack, String entry) {
        Object ores;
        if (stack == ItemStack.field_190927_a || stack.func_77973_b() == null) {
            return false;
        }
        if (oreMap.containsKey(entry)) {
            ores = oreMap.get(entry);
        } else {
            ores = OreDictionary.getOres((String)entry);
            oreMap.put(entry, (List<ItemStack>)ores);
        }
        Iterator iterator = ores.iterator();
        while (iterator.hasNext()) {
            ItemStack ostack = (ItemStack)iterator.next();
            ItemStack cstack = ostack.func_77946_l();
            if (cstack.func_77952_i() == Short.MAX_VALUE) {
                cstack.func_77964_b(stack.func_77952_i());
            }
            if (!stack.func_77969_a(cstack)) continue;
            return true;
        }
        return false;
    }

    void craftItem() {
        ProcessRecipe recipe = this.recipeToCraft();
        boolean worked = false;
        if (recipe != null) {
            if (!this.field_145850_b.field_72995_K) {
                this.getInventory().extractItem(1, ((ItemStack)recipe.getInputs().get(0)).func_190916_E(), false);
                this.field_145850_b.func_175698_g(this.field_174879_c.func_177979_c(1));
                ItemStack gemStack = this.getInventory().getStackInSlot(0);
                if (gemStack != ItemStack.field_190927_a && gemStack.func_77973_b() instanceof ItemHealthGem) {
                    ItemHealthGem healthGem = (ItemHealthGem)gemStack.func_77973_b();
                    gemStack.func_77978_p().func_74768_a("health", gemStack.func_77978_p().func_74762_e("health") - (int)recipe.getIntParameter());
                }
                ItemStack stack = recipe.getOutputs().get(0).func_77946_l();
                EntityItem entity = new EntityItem(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() - 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), stack);
                this.field_145850_b.func_72838_d((Entity)entity);
            }
            if (worked) {
                this.field_145850_b.func_175688_a(EnumParticleTypes.HEART, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() - 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public int getHealthInGem() {
        ItemStack gemStack = this.getInventory().getStackInSlot(0);
        if (gemStack != ItemStack.field_190927_a && gemStack.func_77973_b() instanceof ItemHealthGem) {
            ItemHealthGem healthGem = (ItemHealthGem)gemStack.func_77973_b();
            return healthGem.getHealthInjected(gemStack);
        }
        return 0;
    }

    public ProcessRecipe recipeToCraft() {
        ProcessRecipe recipe;
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1));
        if (state != null && (recipe = ProcessRecipeManager.infusionRecipes.getRecipe(new ArrayList<Object>(Arrays.asList(this.getInventory().getStackInSlot(1), new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state)))), (float)this.getHealthInGem(), false, false)) != null && recipe.getIntParameter() <= (float)this.getHealthInGem()) {
            return recipe;
        }
        return null;
    }
}

