/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.base.item;

import com.bartz24.skyresources.base.MachineVariants;
import com.bartz24.skyresources.base.gui.GuiCasing;
import com.bartz24.skyresources.base.gui.GuiHelper;
import com.bartz24.skyresources.base.tile.TileCasing;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMachine
extends Item {
    public boolean useHeatInfo;
    public boolean useFuelInfo;
    public boolean useSpeedInfo;
    public boolean useEfficiencyInfo;

    public ItemMachine(String baseName, CreativeTabs tab, boolean showHeatInfo, boolean showFuelInfo, boolean showSpeedInfo, boolean showEfficiencyInfo) {
        this.func_77655_b("skyresources." + baseName + ".");
        this.setRegistryName(baseName);
        this.func_77627_a(true);
        this.func_77637_a(tab);
        this.useHeatInfo = showHeatInfo;
        this.useFuelInfo = showFuelInfo;
        this.useSpeedInfo = showSpeedInfo;
        this.useEfficiencyInfo = showEfficiencyInfo;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + MachineVariants.values()[stack.func_77960_j()].func_176610_l();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs creativeTab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(creativeTab)) {
            for (int i = 0; i < MachineVariants.values().length; ++i) {
                list.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    public ItemStack getStack(MachineVariants variant) {
        return new ItemStack((Item)this, 1, Arrays.asList(MachineVariants.values()).indexOf((Object)variant));
    }

    public MachineVariants getVariant(ItemStack stack) {
        return MachineVariants.values()[stack.func_77960_j()];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.useSpeedInfo) {
            tooltip.add(TextFormatting.BLUE + "Speed: " + (int)Math.ceil(this.getVariant(stack).getRawSpeed() * 100.0f) + "%");
        }
        if (this.useEfficiencyInfo) {
            tooltip.add(TextFormatting.GREEN + "Efficiency: " + (int)Math.ceil(this.getVariant(stack).getRawEfficiency() * 100.0f) + "%");
        }
        if (this.useHeatInfo) {
            tooltip.add(TextFormatting.RED + "Max HU: " + this.getVariant(stack).getMaxHeat());
        }
        if (this.useFuelInfo) {
            tooltip.add(TextFormatting.YELLOW + this.getFuelDisplay(stack, worldIn, null)[0]);
            tooltip.add(TextFormatting.YELLOW + this.getFuelDisplay(stack, worldIn, null)[1]);
        }
    }

    public void update(World world, BlockPos pos, ItemStack machineStack, NBTTagCompound data) {
    }

    public TileCasing getCasingTile(World world, BlockPos pos) {
        return (TileCasing)world.func_175625_s(pos);
    }

    public float getMachineSpeed(ItemStack stack, World world, BlockPos pos) {
        return this.getVariant(stack).getRawSpeed();
    }

    public float getMachineEfficiency(ItemStack stack, @Nullable World world, BlockPos pos) {
        if (pos == null) {
            return this.getVariant(stack).getRawEfficiency();
        }
        return this.getVariant(stack).getRawEfficiency() * MachineVariants.values()[world.func_180495_p(pos).func_177230_c().func_176201_c(world.func_180495_p(pos))].getRawEfficiency();
    }

    public float[] getMachineFuelData(ItemStack stack, World world, BlockPos pos) {
        if (this.getVariant(stack).getFuelType().equals("RF")) {
            float[] data = new float[]{this.getHUPerTick(stack, world, pos, this.useSpeedInfo), this.rfgetRFPerTick(stack, world, pos, this.useFuelInfo, this.useSpeedInfo, this.useEfficiencyInfo), this.rfgetRFPerHU(stack, world, pos, this.useFuelInfo, this.useEfficiencyInfo)};
            return data;
        }
        float[] data = new float[]{this.getHUPerTick(stack, world, pos, this.useSpeedInfo), this.fuelgetFuelTimePercent(stack, world, pos, this.useFuelInfo, this.useSpeedInfo, this.useEfficiencyInfo), this.fuelgetAmountPerHU(stack, world, pos, this.useSpeedInfo, this.useEfficiencyInfo), this.fuelgetAmountPerTick()};
        return data;
    }

    public String[] getFuelDisplay(ItemStack stack, World world, BlockPos pos) {
        String[] list = new String[]{"Fuel: ", TextFormatting.RED.toString() + this.getHUPerTick(stack, world, pos, this.useSpeedInfo) + " HU/tick" + TextFormatting.YELLOW};
        if (this.getVariant(stack).getFuelType().equals("RF")) {
            list[0] = list[0] + Math.ceil(this.rfgetRFPerTick(stack, world, pos, this.useFuelInfo, this.useSpeedInfo, this.useEfficiencyInfo)) + " RF/tick";
        } else if (this.getVariant(stack).getFuelType().equals("Fuel")) {
            list[0] = list[0] + "Furnace Fuels last for x" + Math.floor(this.fuelgetFuelTimePercent(stack, world, pos, this.useFuelInfo, this.useSpeedInfo, this.useEfficiencyInfo) * 100.0f) / 100.0 + " ticks";
        } else if (this.getVariant(stack).getFuelType() instanceof ItemStack) {
            list[0] = list[0] + ((ItemStack)this.getVariant(stack).getFuelType()).func_82833_r() + " lasts for " + Math.floor(this.fuelgetFuelTimePercent(stack, world, pos, this.useFuelInfo, this.useSpeedInfo, this.useEfficiencyInfo) * 100.0f) / 100.0 + " ticks";
        } else if (this.getVariant(stack).getFuelType() instanceof Fluid) {
            list[0] = list[0] + ((Fluid)this.getVariant(stack).getFuelType()).getLocalizedName(new FluidStack((Fluid)this.getVariant(stack).getFuelType(), 1)) + " lasts for " + Math.floor(this.fuelgetFuelTimePercent(stack, world, pos, this.useFuelInfo, this.useSpeedInfo, this.useEfficiencyInfo) * 100.0f) / 100.0 + " ticks";
        }
        return list;
    }

    public List<Slot> getSlots(TileCasing tile) {
        return new ArrayList<Slot>();
    }

    public int[] getInvPos(ItemStack stack) {
        return new int[]{0, 0};
    }

    public int[] getGuiSize(ItemStack stack) {
        return new int[]{176, 166};
    }

    public void initGui(GuiCasing gui, List buttonList) {
    }

    public void actionPerformed(TileCasing tile, GuiCasing gui, int buttonClicked) throws IOException {
    }

    public void drawBackgroundGui(TileCasing tile, GuiCasing gui, FontRenderer fontRenderer, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("skyresources", "textures/gui/blankInventory.png"));
        gui.func_73729_b(gui.getGuiLeft(), gui.getGuiTop(), 0, 0, gui.getXSize(), gui.getYSize());
    }

    public void drawForegroundGui(TileCasing tile, GuiCasing gui, FontRenderer fontRenderer, int mouseX, int mouseY) {
        if (!tile.machineStored.func_190926_b()) {
            String s;
            int y = 20;
            int hoverY = 0;
            int hoverX = 0;
            String hoverString = "";
            if (tile.getMachine().useSpeedInfo) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("skyresources", "textures/gui/guiicons.png"));
                gui.func_73729_b(gui.getXSize() - 18, y, 0, 44, 14, 14);
                s = (int)Math.ceil(tile.getMachine().getMachineSpeed(tile.machineStored, tile.func_145831_w(), tile.func_174877_v()) * 100.0f) + "%";
                fontRenderer.func_78276_b(s, gui.getXSize() - fontRenderer.func_78256_a(s) - 24, y + 3, -16768812);
                if (GuiHelper.isMouseInRect(gui.getGuiLeft() + gui.getXSize() - fontRenderer.func_78256_a(s) - 24, gui.getGuiTop() + y, fontRenderer.func_78256_a(s) + 24, 16, mouseX, mouseY)) {
                    hoverString = "Speed";
                    hoverY = y;
                    hoverX = fontRenderer.func_78256_a(s) + 24;
                }
                y += 14;
            }
            if (tile.getMachine().useEfficiencyInfo) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("skyresources", "textures/gui/guiicons.png"));
                gui.func_73729_b(gui.getXSize() - 18, y, 18, 44, 14, 14);
                s = (int)Math.ceil(tile.getMachine().getMachineEfficiency(tile.machineStored, tile.func_145831_w(), tile.func_174877_v()) * 100.0f) + "%";
                fontRenderer.func_78276_b(s, gui.getXSize() - fontRenderer.func_78256_a(s) - 24, y + 3, -16721148);
                if (GuiHelper.isMouseInRect(gui.getGuiLeft() + gui.getXSize() - fontRenderer.func_78256_a(s) - 24, gui.getGuiTop() + y, fontRenderer.func_78256_a(s) + 24, 16, mouseX, mouseY)) {
                    hoverString = "Efficiency/Production";
                    hoverY = y;
                    hoverX = fontRenderer.func_78256_a(s) + 24;
                }
                y += 14;
            }
            if (tile.getMachine().useFuelInfo) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("skyresources", "textures/gui/guiicons.png"));
                gui.func_73729_b(gui.getXSize() - 18, y, 0, 58, 14, 14);
                float fuelAmt = this.getMachineFuelData(tile.machineStored, tile.func_145831_w(), tile.func_174877_v())[1];
                if (!tile.getMachine().getVariant(tile.machineStored).getFuelType().equals("RF")) {
                    fuelAmt = this.getMachineFuelData(tile.machineStored, tile.func_145831_w(), tile.func_174877_v())[3];
                }
                String s2 = Float.toString((float)Math.round(fuelAmt * 100.0f) / 100.0f);
                fontRenderer.func_78276_b(s2, gui.getXSize() - fontRenderer.func_78256_a(s2) - 24, y + 3, -786665);
                if (GuiHelper.isMouseInRect(gui.getGuiLeft() + gui.getXSize() - fontRenderer.func_78256_a(s2) - 24, gui.getGuiTop() + y, fontRenderer.func_78256_a(s2) + 24, 16, mouseX, mouseY)) {
                    hoverString = "Fuel/Tick";
                    hoverY = y;
                    hoverX = fontRenderer.func_78256_a(s2) + 24;
                }
            }
            if (!Strings.isNullOrEmpty((String)hoverString) && GuiHelper.isMouseInRect(gui.getGuiLeft() + gui.getXSize() - hoverX, gui.getGuiTop() + hoverY, hoverX, 16, mouseX, mouseY)) {
                int k = (gui.field_146294_l - gui.getXSize()) / 2;
                int l = (gui.field_146295_m - gui.getYSize()) / 2;
                ArrayList<String> list = new ArrayList<String>();
                list.add(hoverString);
                gui.drawHoveringText(list, mouseX - k, mouseY - l, fontRenderer);
            }
        }
    }

    public int getMaxEnergy(ItemStack stack) {
        return 0;
    }

    public int getMaxExtract(ItemStack stack) {
        return 0;
    }

    public int getMaxReceive(ItemStack stack) {
        return 0;
    }

    public int getItemSlots(ItemStack stack) {
        return 0;
    }

    public int[] getInsertBlacklist(ItemStack stack) {
        return new int[0];
    }

    public int[] getExtractBlacklist(ItemStack stack) {
        return new int[0];
    }

    public Fluid getFluid(ItemStack stack) {
        return null;
    }

    public int getMaxFluid(ItemStack stack) {
        return 0;
    }

    public int getHeatProv(ItemStack stack, World world, BlockPos pos) {
        return 0;
    }

    public float getHUPerTick(ItemStack stack, World world, BlockPos pos, boolean useSpeedInfo) {
        float spd = useSpeedInfo ? this.getMachineSpeed(stack, world, pos) : 1.0f;
        return spd * 10.0f;
    }

    public float rfgetRFPerHU(ItemStack stack, World world, BlockPos pos, boolean useFuelInfo, boolean useEfficiencyInfo) {
        if (useFuelInfo) {
            float rate = this.getVariant(stack).getRawFuelRate();
            float eff = useEfficiencyInfo ? this.getMachineEfficiency(stack, world, pos) : 1.0f;
            return rate / eff;
        }
        return 0.0f;
    }

    public float rfgetRFPerTick(ItemStack stack, World world, BlockPos pos, boolean useFuelInfo, boolean useSpeedInfo, boolean useEfficiencyInfo) {
        return this.getHUPerTick(stack, world, pos, useSpeedInfo) * this.rfgetRFPerHU(stack, world, pos, useFuelInfo, useEfficiencyInfo);
    }

    public float fuelgetAmountPerTick() {
        return 1.0f;
    }

    public float fuelgetFuelTimePercent(ItemStack stack, World world, BlockPos pos, boolean useFuelInfo, boolean useSpeedInfo, boolean useEfficiencyInfo) {
        float rate = useFuelInfo ? (float)(this.getVariant(stack).getFuelType() instanceof ItemStack ? this.getVariant(stack).getRawFuelRate() : 1) : 1.0f;
        float spd = useSpeedInfo ? this.getMachineSpeed(stack, world, pos) : 1.0f;
        float eff = useEfficiencyInfo ? this.getMachineEfficiency(stack, world, pos) : 1.0f;
        return rate / this.getHUPerTick(stack, world, pos, useSpeedInfo) * eff;
    }

    public float fuelgetAmountPerHU(ItemStack stack, World world, BlockPos pos, boolean useSpeedInfo, boolean useEfficiencyInfo) {
        return this.getHUPerTick(stack, world, pos, useSpeedInfo) * this.fuelgetAmountPerTick();
    }
}

