/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.recipe;

import com.bartz24.skyresources.RandomHelper;
import com.bartz24.skyresources.SkyResources;
import com.bartz24.skyresources.recipe.ProcessRecipe;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ProcessRecipeManager {
    private String type;
    public static ProcessRecipeManager combustionRecipes = new ProcessRecipeManager("combustion"){

        @Override
        public void drawJEIInfo(ProcessRecipe rec, Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            String s = Integer.toString((int)rec.getIntParameter()) + " HU";
            FontRenderer fontRendererObj = minecraft.field_71466_p;
            int stringWidth = fontRendererObj.func_78256_a(s);
            fontRendererObj.func_78276_b(s, 118 - stringWidth, 8, Color.gray.getRGB());
        }
    };
    public static ProcessRecipeManager infusionRecipes = new ProcessRecipeManager("infusion"){

        @Override
        public void drawJEIInfo(ProcessRecipe rec, Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            String s = "x" + Float.toString(rec.getIntParameter() / 2.0f);
            FontRenderer fontRendererObj = minecraft.field_71466_p;
            fontRendererObj.func_78276_b(s, 80, 0, Color.gray.getRGB());
        }
    };
    public static ProcessRecipeManager rockGrinderRecipes = new ProcessRecipeManager("rockgrinder"){

        @Override
        public void drawJEIInfo(ProcessRecipe rec, Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            String s = (float)Math.round(rec.getIntParameter() * 100000.0f) / 1000.0f + "%";
            FontRenderer fontRendererObj = minecraft.field_71466_p;
            fontRendererObj.func_78276_b(s, 96 - fontRendererObj.func_78256_a(s), 4, Color.gray.getRGB());
        }
    };
    public static ProcessRecipeManager knifeRecipes = new ProcessRecipeManager("knife");
    public static ProcessRecipeManager crucibleRecipes = new ProcessRecipeManager("crucible");
    public static ProcessRecipeManager freezerRecipes = new ProcessRecipeManager("freezer"){

        @Override
        public void drawJEIInfo(ProcessRecipe rec, Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            String s = Float.toString(rec.getIntParameter()) + " ticks";
            FontRenderer fontRendererObj = minecraft.field_71466_p;
            fontRendererObj.func_78276_b(s, 1, 3, Color.gray.getRGB());
        }
    };
    public static ProcessRecipeManager waterExtractorInsertRecipes = new ProcessRecipeManager("waterextractor-insert"){

        @Override
        public void drawJEIInfo(ProcessRecipe rec, Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            FontRenderer fontRendererObj = minecraft.field_71466_p;
            fontRendererObj.func_78276_b("Inserting", 65, 0, Color.gray.getRGB());
        }
    };
    public static ProcessRecipeManager waterExtractorExtractRecipes = new ProcessRecipeManager("waterextractor-extract"){

        @Override
        public void drawJEIInfo(ProcessRecipe rec, Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            FontRenderer fontRendererObj = minecraft.field_71466_p;
            fontRendererObj.func_78276_b("Extracting", 65, 0, Color.gray.getRGB());
        }
    };
    public static ProcessRecipeManager cauldronCleanRecipes = new ProcessRecipeManager("cauldronclean"){

        @Override
        public void drawJEIInfo(ProcessRecipe rec, Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            String s = Float.toString((float)Math.round(rec.getIntParameter() * 100000.0f) / 1000.0f) + "%";
            FontRenderer fontRendererObj = minecraft.field_71466_p;
            fontRendererObj.func_78276_b(s, 106 - fontRendererObj.func_78256_a(s), 34, Color.gray.getRGB());
        }
    };
    public static ProcessRecipeManager condenserRecipes = new ProcessRecipeManager("condenser"){

        @Override
        public void drawJEIInfo(ProcessRecipe rec, Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            String s = Math.round(rec.getIntParameter()) + " ticks";
            FontRenderer fontRendererObj = minecraft.field_71466_p;
            int stringWidth = fontRendererObj.func_78256_a(s);
            fontRendererObj.func_78276_b(s, 124 - stringWidth, 44, Color.gray.getRGB());
            double dustPerTick = Math.pow(rec.getIntParameter(), 1.3f) / 50.0 / (double)(2400.0f * rec.getIntParameter() / 50.0f);
            s = (float)Math.round(1.0 / dustPerTick / (double)rec.getIntParameter() * 10000.0) / 10000.0f + "x output";
            stringWidth = fontRendererObj.func_78256_a(s);
            fontRendererObj.func_78276_b(s, 124 - stringWidth, 54, Color.gray.getRGB());
            s = "At 100% SPD/EFF";
            stringWidth = fontRendererObj.func_78256_a(s);
            fontRendererObj.func_78276_b(s, 86 - stringWidth / 2, 34, Color.gray.getRGB());
        }
    };
    public static ProcessRecipeManager fusionRecipes = new ProcessRecipeManager("fusion"){

        @Override
        public void drawJEIInfo(ProcessRecipe rec, Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            String s = Integer.toString((int)(rec.getIntParameter() * 10000.0f)) + "% of catalyst used";
            FontRenderer fontRendererObj = minecraft.field_71466_p;
            int stringWidth = fontRendererObj.func_78256_a(s);
            fontRendererObj.func_78276_b(s, 118 - stringWidth, 0, Color.gray.getRGB());
        }
    };
    private static List<ProcessRecipeManager> managers;
    private List<ProcessRecipe> recipes = new ArrayList<ProcessRecipe>();
    private List<ProcessRecipe> ctRemovedRecipes = new ArrayList<ProcessRecipe>();
    private List<ProcessRecipe> ctAddedRecipes = new ArrayList<ProcessRecipe>();

    public static List<ProcessRecipeManager> getManagers() {
        return managers;
    }

    public ProcessRecipeManager(String recipeType) {
        this.type = recipeType;
        if (managers == null) {
            managers = new ArrayList<ProcessRecipeManager>();
        }
        managers.add(this);
    }

    public static ProcessRecipeManager getManagerFromType(String type) {
        for (ProcessRecipeManager m : managers) {
            if (!m.type.equals(type)) continue;
            return m;
        }
        return null;
    }

    public ProcessRecipe getRecipe(List<Object> input, float intVal, boolean forceEqual, boolean mergeStacks) {
        input = mergeStacks ? this.mergeStacks(input) : input;
        ProcessRecipe rec = new ProcessRecipe(input, intVal, this.type);
        for (ProcessRecipe recipe : this.recipes) {
            if (!rec.isInputRecipeEqualTo(recipe, forceEqual)) continue;
            return recipe;
        }
        return null;
    }

    public ProcessRecipe compareRecipeLess(List<Object> input, float intVal, boolean mergeStacks, ProcessRecipe recipe) {
        input = mergeStacks ? this.mergeStacks(input) : input;
        ProcessRecipe rec = new ProcessRecipe(input, intVal, this.type);
        if (rec.isInputRecipeLess(recipe)) {
            return recipe;
        }
        return null;
    }

    public ProcessRecipe getRecipe(Object input, float intVal, boolean forceEqual, boolean mergeStacks) {
        List<Object> inputs = mergeStacks ? this.mergeStacks(Collections.singletonList(input)) : Collections.singletonList(input);
        ProcessRecipe rec = new ProcessRecipe(inputs, intVal, this.type);
        for (ProcessRecipe recipe : this.recipes) {
            if (!rec.isInputRecipeEqualTo(recipe, forceEqual)) continue;
            return recipe;
        }
        return null;
    }

    public ProcessRecipe getMultiRecipe(List<Object> input, float intVal) {
        ProcessRecipe rec = new ProcessRecipe(input, intVal, this.type);
        for (ProcessRecipe recipe : this.recipes) {
            if (!rec.isInputMultiRecipeEqualTo(recipe)) continue;
            return recipe;
        }
        return null;
    }

    private List<Object> mergeStacks(List<Object> input) {
        boolean merged = true;
        for (int checks = 0; merged && checks < 50; ++checks) {
            int i;
            merged = false;
            for (i = 0; i < input.size(); ++i) {
                if (!(input.get(i) instanceof ItemStack)) continue;
                ItemStack stack1 = (ItemStack)input.get(i);
                for (int i2 = i + 1; i2 < input.size(); ++i2) {
                    ItemStack stack2;
                    if (!(input.get(i2) instanceof ItemStack) || !RandomHelper.canStacksMerge(stack2 = (ItemStack)input.get(i2), stack1)) continue;
                    stack1.func_190917_f(stack2.func_190916_E());
                    stack2.func_190920_e(0);
                    if (stack2.func_190916_E() <= 0) {
                        stack2 = ItemStack.field_190927_a;
                    }
                    merged = true;
                    break;
                }
                if (merged) break;
            }
            for (i = input.size() - 1; i >= 0; --i) {
                ItemStack stack;
                if (!(input.get(i) instanceof ItemStack) || (stack = (ItemStack)input.get(i)) != ItemStack.field_190927_a) continue;
                input.remove(i);
            }
        }
        return input;
    }

    public List<ProcessRecipe> getRecipes() {
        return this.recipes;
    }

    public void addRecipe(List<Object> output, float intVal, List<Object> input) {
        if (input == null) {
            SkyResources.logger.error("Need inputs for recipe. DID NOT ADD RECIPE.");
            return;
        }
        if (output == null) {
            SkyResources.logger.error("Need outputs for recipe. DID NOT ADD RECIPE.");
            return;
        }
        this.recipes.add(new ProcessRecipe(output, input, intVal, this.type));
    }

    public void addRecipe(Object output, float intVal, Object input) {
        if (input == null) {
            SkyResources.logger.error("Need inputs for recipe. DID NOT ADD RECIPE.");
            return;
        }
        if (output == null) {
            SkyResources.logger.error("Need outputs for recipe. DID NOT ADD RECIPE.");
            return;
        }
        this.recipes.add(new ProcessRecipe(Collections.singletonList(output), Collections.singletonList(input), intVal, this.type));
    }

    public void addRecipe(List<Object> output, float intVal, Object input) {
        if (input == null) {
            SkyResources.logger.error("Need inputs for recipe. DID NOT ADD RECIPE.");
            return;
        }
        if (output == null) {
            SkyResources.logger.error("Need outputs for recipe. DID NOT ADD RECIPE.");
            return;
        }
        this.recipes.add(new ProcessRecipe(output, Collections.singletonList(input), intVal, this.type));
    }

    public void addRecipe(Object output, float intVal, List<Object> input) {
        if (input == null) {
            SkyResources.logger.error("Need inputs for recipe. DID NOT ADD RECIPE.");
            return;
        }
        if (output == null) {
            SkyResources.logger.error("Need outputs for recipe. DID NOT ADD RECIPE.");
            return;
        }
        this.recipes.add(new ProcessRecipe(Collections.singletonList(output), input, intVal, this.type));
    }

    public void addRecipe(ProcessRecipe recipe) {
        if (!(recipe.getInputs() != null && recipe.getInputs().size() != 0 || recipe.getFluidInputs() != null && recipe.getFluidInputs().size() != 0)) {
            SkyResources.logger.error("Need inputs for recipe. DID NOT ADD RECIPE.");
            return;
        }
        if (!(recipe.getOutputs() != null && recipe.getOutputs().size() != 0 || recipe.getFluidOutputs() != null && recipe.getFluidOutputs().size() != 0)) {
            SkyResources.logger.error("Need outputs for recipe. DID NOT ADD RECIPE.");
            return;
        }
        this.recipes.add(recipe);
    }

    public void addCTRecipe(ProcessRecipe recipe) {
        if (!(recipe.getInputs() != null && recipe.getInputs().size() != 0 || recipe.getFluidInputs() != null && recipe.getFluidInputs().size() != 0)) {
            SkyResources.logger.error("Need inputs for recipe. DID NOT ADD RECIPE.");
            return;
        }
        if (!(recipe.getOutputs() != null && recipe.getOutputs().size() != 0 || recipe.getFluidOutputs() != null && recipe.getFluidOutputs().size() != 0)) {
            SkyResources.logger.error("Need outputs for recipe. DID NOT ADD RECIPE.");
            return;
        }
        this.ctAddedRecipes.add(recipe);
    }

    public void ctRecipes() {
        for (ProcessRecipe recipe : this.ctRemovedRecipes) {
            this.removeRecipe(recipe);
        }
        for (ProcessRecipe r : this.ctAddedRecipes) {
            this.addRecipe(r);
        }
    }

    public void removeRecipe(ProcessRecipe recipe) {
        int i;
        if (!(recipe.getOutputs() != null && recipe.getOutputs().size() != 0 || recipe.getFluidOutputs() != null && recipe.getFluidOutputs().size() != 0)) {
            SkyResources.logger.error("Need outputs for recipe. DID NOT REMOVE RECIPE.");
            return;
        }
        if (!(recipe.getInputs() != null && recipe.getInputs().size() != 0 || recipe.getFluidInputs() != null && recipe.getFluidInputs().size() != 0)) {
            ArrayList<Integer> recipesToRemoveAt = new ArrayList<Integer>();
            for (int i2 = 0; i2 < this.recipes.size(); ++i2) {
                boolean valid = true;
                for (ItemStack itemStack : this.recipes.get(i2).getOutputs()) {
                    for (ItemStack itemStack2 : recipe.getOutputs()) {
                        if (itemStack.func_77969_a(itemStack2)) continue;
                        valid = false;
                    }
                }
                for (FluidStack fluidStack : this.recipes.get(i2).getFluidOutputs()) {
                    for (FluidStack fluidStack2 : recipe.getFluidOutputs()) {
                        if (fluidStack.isFluidEqual(fluidStack2)) continue;
                        valid = false;
                    }
                }
                if (!valid) continue;
                recipesToRemoveAt.add(i2);
            }
            for (int i2 = recipesToRemoveAt.size() - 1; i2 >= 0; --i2) {
                this.recipes.remove((Integer)recipesToRemoveAt.get(i2));
            }
            return;
        }
        ArrayList<Integer> recipesToRemoveAt = new ArrayList<Integer>();
        for (i = 0; i < this.recipes.size(); ++i) {
            if (!this.recipes.get(i).isInputRecipeEqualTo(recipe, false)) continue;
            boolean valid = true;
            for (ItemStack itemStack : this.recipes.get(i).getOutputs()) {
                for (ItemStack itemStack3 : recipe.getOutputs()) {
                    if (itemStack.func_190926_b() && itemStack3.func_190926_b() || itemStack.func_77969_a(itemStack3)) continue;
                    valid = false;
                }
            }
            for (FluidStack fluidStack : this.recipes.get(i).getFluidOutputs()) {
                for (FluidStack fluidStack3 : recipe.getFluidOutputs()) {
                    if (fluidStack.isFluidEqual(fluidStack3)) continue;
                    valid = false;
                }
            }
            if (!valid) continue;
            recipesToRemoveAt.add(i);
        }
        for (i = recipesToRemoveAt.size() - 1; i >= 0; --i) {
            this.recipes.remove((Integer)recipesToRemoveAt.get(i));
        }
    }

    public void removeCTRecipe(ProcessRecipe recipe) {
        this.ctRemovedRecipes.add(recipe);
    }

    public void drawJEIInfo(ProcessRecipe rec, Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
    }
}

