/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.technology.tile;

import com.bartz24.skyresources.base.tile.TileGenericPower;
import com.bartz24.skyresources.config.ConfigOptions;
import com.bartz24.skyresources.registry.ModItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileWildlifeAttractor
extends TileGenericPower
implements ITickable,
IFluidHandler {
    private FluidTank tank;
    private int powerUsage;
    private int matterTime;
    private int fluidUsage;
    private int matterLeft;

    public TileWildlifeAttractor() {
        super("wildlifeAttractor", 100000, 2000, 0, 1, null, new int[]{0});
        this.powerUsage = ConfigOptions.machineSettings.wildlifeAttractorPowerUsage;
        this.matterTime = ConfigOptions.machineSettings.wildlifeAttractorMatterTime;
        this.fluidUsage = ConfigOptions.machineSettings.wildlifeAttractorWaterUsage;
        this.matterLeft = 0;
        this.tank = new FluidTank(ConfigOptions.machineSettings.wildlifeAttractorWaterCapacity);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.getRedstoneSignal() == 0) {
            if (this.matterLeft <= 0 && !this.getInventory().getStackInSlot(0).func_190926_b() && this.getInventory().getStackInSlot(0).func_77969_a(new ItemStack(ModItems.baseComponent, 1, 0))) {
                this.getInventory().getStackInSlot(0).func_190918_g(1);
                this.matterLeft = this.matterTime + 0;
            }
            if (this.tank.getFluidAmount() >= this.fluidUsage && this.tank.getFluid().getFluid() == FluidRegistry.WATER && this.energy >= this.powerUsage && this.matterLeft > 0) {
                this.spawnRandomAnimal();
                this.tank.drain(this.fluidUsage, true);
                this.energy -= this.powerUsage;
                --this.matterLeft;
            }
        }
        this.func_70296_d();
    }

    public int getMatterLeft() {
        return this.matterLeft;
    }

    void spawnRandomAnimal() {
        if (this.field_145850_b.field_73012_v.nextInt(600) == 0) {
            String randomID = ConfigOptions.machineSettings.wildlifeAttractorAnimalIDs[this.field_145850_b.field_73012_v.nextInt(ConfigOptions.machineSettings.wildlifeAttractorAnimalIDs.length)];
            EntityLiving e = (EntityLiving)EntityList.func_188429_b((ResourceLocation)new ResourceLocation(randomID), (World)this.field_145850_b);
            e.func_70012_b((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 1.0f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
            Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)e, (World)this.field_145850_b, (float)((float)this.field_174879_c.func_177958_n() + 0.5f), (float)((float)this.field_174879_c.func_177956_o() + 1.0f), (float)((float)this.field_174879_c.func_177952_p() + 0.5f), (boolean)false);
            boolean isNotColliding = e.func_70058_J();
            if (canSpawn == Event.Result.ALLOW || canSpawn == Event.Result.DEFAULT && isNotColliding) {
                if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)e, (World)this.field_145850_b, (float)((float)this.field_174879_c.func_177958_n() + 0.5f), (float)((float)this.field_174879_c.func_177956_o() + 1.0f), (float)((float)this.field_174879_c.func_177952_p() + 0.5f))) {
                    e.func_180482_a(this.field_145850_b.func_175649_E(new BlockPos((Entity)e)), null);
                }
                if (e.func_70058_J()) {
                    this.field_145850_b.func_72838_d((Entity)e);
                } else {
                    e.func_70106_y();
                }
            }
        }
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && resource.getFluid() == FluidRegistry.WATER) {
            int filled = this.tank.fill(resource, doFill);
            return filled;
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74768_a("matter", this.matterLeft);
        this.tank.writeToNBT(compound);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.matterLeft = compound.func_74762_e("matter");
        this.tank.readFromNBT(compound);
    }

    public FluidTank getTank() {
        return this.tank;
    }
}

