/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.particle;

import mekanism.api.EnumColor;
import mekanism.client.render.particle.TieredParticleDigging;
import mekanism.common.base.ITieredTile;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MekanismParticleHelper {
    private static final double OFFSET_1 = (double)0.2f;
    private static final double OFFSET_2 = (double)0.1f;

    public static boolean addBlockHitEffects(World world, BlockPos pos, EnumFacing side, ParticleManager manager) {
        TileEntity tile = MekanismUtils.getTileEntitySafe((IBlockAccess)world, pos);
        EnumColor color = null;
        IBlockState iblockstate = world.func_180495_p(pos);
        iblockstate = iblockstate.func_177230_c().func_176221_a(iblockstate, (IBlockAccess)world, pos);
        if (tile instanceof ITieredTile) {
            color = ((ITieredTile)tile).getTier().getColor();
        }
        if (iblockstate.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
            int blockX = pos.func_177958_n();
            int blockY = pos.func_177956_o();
            int blockZ = pos.func_177952_p();
            AxisAlignedBB axisalignedbb = iblockstate.func_185900_c((IBlockAccess)world, pos);
            double particleX = (double)blockX + world.field_73012_v.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)0.2f) + (double)0.1f + axisalignedbb.field_72340_a;
            double particleY = (double)blockY + world.field_73012_v.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)0.2f) + (double)0.1f + axisalignedbb.field_72338_b;
            double particleZ = (double)blockZ + world.field_73012_v.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)0.2f) + (double)0.1f + axisalignedbb.field_72339_c;
            if (side == EnumFacing.DOWN) {
                particleY = (double)blockY + axisalignedbb.field_72338_b - (double)0.1f;
            }
            if (side == EnumFacing.UP) {
                particleY = (double)blockY + axisalignedbb.field_72337_e + (double)0.1f;
            }
            if (side == EnumFacing.NORTH) {
                particleZ = (double)blockZ + axisalignedbb.field_72339_c - (double)0.1f;
            }
            if (side == EnumFacing.SOUTH) {
                particleZ = (double)blockZ + axisalignedbb.field_72334_f + (double)0.1f;
            }
            if (side == EnumFacing.WEST) {
                particleX = (double)blockX + axisalignedbb.field_72340_a - (double)0.1f;
            }
            if (side == EnumFacing.EAST) {
                particleX = (double)blockX + axisalignedbb.field_72336_d + (double)0.1f;
            }
            manager.func_78873_a(new TieredParticleDigging(world, particleX, particleY, particleZ, 0.0, 0.0, 0.0, iblockstate, color).func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f));
        }
        return true;
    }
}

