/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.api.TileNetworkList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.tier.InductionCellTier;
import mekanism.common.tile.prefab.TileEntityBasicBlock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityInductionCell
extends TileEntityBasicBlock
implements IStrictEnergyStorage {
    public InductionCellTier tier = InductionCellTier.BASIC;
    public double electricityStored;

    @Override
    public void onUpdate() {
    }

    public String getName() {
        return LangUtils.localize(this.func_145838_q().func_149739_a() + ".InductionCell" + this.tier.getBaseTier().getSimpleName() + ".name");
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            InductionCellTier prevTier = this.tier;
            this.tier = InductionCellTier.values()[dataStream.readInt()];
            super.handlePacketData(dataStream);
            this.electricityStored = dataStream.readDouble();
            if (prevTier != this.tier) {
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        data.add(this.tier.ordinal());
        super.getNetworkedData(data);
        data.add(this.electricityStored);
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.tier = InductionCellTier.values()[nbtTags.func_74762_e("tier")];
        this.electricityStored = nbtTags.func_74769_h("electricityStored");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("tier", this.tier.ordinal());
        nbtTags.func_74780_a("electricityStored", this.electricityStored);
        return nbtTags;
    }

    @Override
    public double getEnergy() {
        return this.electricityStored;
    }

    @Override
    public void setEnergy(double energy) {
        this.electricityStored = Math.min(energy, this.getMaxEnergy());
    }

    @Override
    public double getMaxEnergy() {
        return this.tier.getMaxEnergy();
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == Capabilities.ENERGY_STORAGE_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == Capabilities.ENERGY_STORAGE_CAPABILITY) {
            return (T)Capabilities.ENERGY_STORAGE_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }
}

