/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.api.client.shader;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import p455w0rdslib.LibGlobals;
import p455w0rdslib.LibShaders;
import p455w0rdslib.api.client.shader.Cam;
import p455w0rdslib.api.client.shader.Light;
import p455w0rdslib.capabilities.CapabilityLightEmitter;
import p455w0rdslib.util.PlayerUtils;

public class LightHandler {
    public static final ArrayList<Light> lights = new ArrayList();
    private static long frameId = 0L;
    private static Vec3d camPos;
    private static Cam camera;
    public static Comparator<Light> distance;

    public static void addLight(Light l) {
        if (camPos.func_186679_c((double)l.x, (double)l.y, (double)l.z) > (double)l.mag + LibGlobals.ConfigOptions.SHADERS_MAX_DIST) {
            return;
        }
        if (camera != null && !camera.func_78546_a(new AxisAlignedBB((double)(l.x - l.mag), (double)(l.y - l.mag), (double)(l.z - l.mag), (double)(l.x + l.mag), (double)(l.y + l.mag), (double)(l.z + l.mag)))) {
            return;
        }
        if (l != null) {
            lights.add(l);
        }
    }

    public static Light getLightForEntity(Entity entity) {
        for (Light light : lights) {
            if (light.entity == null || !light.entity.func_180425_c().equals((Object)entity.func_180425_c())) continue;
            return light;
        }
        return null;
    }

    public static void uploadLights() {
        LibShaders.getActiveShader().getUniform("lightCount").setInt(lights.size());
        if (++frameId < (long)(LibGlobals.ConfigOptions.SHADER_NUM_FRAMES_TO_SKIP + 1)) {
            return;
        }
        frameId = 0L;
        int max = Math.min(lights.size(), LibGlobals.ConfigOptions.MAX_LIGHTS);
        for (int i = 0; i < max; ++i) {
            if (i >= max) continue;
            Light l = lights.get(i);
            LibShaders.getActiveShader().getUniform("lights[" + i + "].position").setFloat(l.x, l.y, l.z);
            LibShaders.getActiveShader().getUniform("lights[" + i + "].color").setFloat(l.r, l.g, l.b, l.a / 2.0f);
            if (LibShaders.getActiveShader() != LibShaders.coloredLightShader) continue;
            LibShaders.getActiveShader().getUniform("lights[" + i + "].rad").setFloat(l.sx, l.sy, l.sz);
            LibShaders.getActiveShader().getUniform("lights[" + i + "].intensity").setFloat(l.l);
        }
    }

    public static void update(World world) {
        if (!world.field_72995_K) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        Entity cameraEntity = mc.func_175606_aa();
        if (cameraEntity == null) {
            if (camPos == null) {
                camPos = new Vec3d(0.0, 0.0, 0.0);
            }
            camera = null;
            return;
        }
        float pt = mc.func_184121_ak();
        camPos = new Vec3d(cameraEntity.field_70142_S + (cameraEntity.field_70165_t - cameraEntity.field_70142_S) * (double)pt, cameraEntity.field_70137_T + (cameraEntity.field_70163_u - cameraEntity.field_70137_T) * (double)pt, cameraEntity.field_70136_U + (cameraEntity.field_70161_v - cameraEntity.field_70136_U) * (double)pt);
        camera = new Cam(LightHandler.camPos.field_72450_a, LightHandler.camPos.field_72448_b, LightHandler.camPos.field_72449_c);
        ArrayList<Light> toAdd = new ArrayList<Light>();
        for (Entity e : world.func_72910_y()) {
            if (e instanceof EntityItem && CapabilityLightEmitter.hasCap(((EntityItem)e).func_92059_d())) {
                toAdd.addAll(CapabilityLightEmitter.getLights(((EntityItem)e).func_92059_d(), e));
            }
            if (!CapabilityLightEmitter.hasCap(e)) continue;
            toAdd.addAll(CapabilityLightEmitter.getLights(e));
            for (ItemStack stack : e.func_184214_aD()) {
                if (!CapabilityLightEmitter.hasCap(stack)) continue;
                toAdd.addAll(CapabilityLightEmitter.getLights(stack, e));
            }
            for (ItemStack stack : e.func_184193_aE()) {
                if (!CapabilityLightEmitter.hasCap(stack)) continue;
                toAdd.addAll(CapabilityLightEmitter.getLights(stack, e));
            }
        }
        for (TileEntity t : world.field_147482_g) {
            if (!CapabilityLightEmitter.hasCap(t)) continue;
            toAdd.addAll(CapabilityLightEmitter.getLights(t));
        }
        toAdd.sort(distance);
        lights.clear();
        lights.addAll((Collection<Light>)ImmutableList.copyOf(toAdd));
    }

    static {
        distance = new Comparator<Light>(){

            @Override
            public int compare(Light light0, Light light1) {
                return Double.compare(this.getDistToLight(light0), this.getDistToLight(light1));
            }

            private double getDistToLight(Light light) {
                return PlayerUtils.getDistanceToPos(light.x, light.y, light.z);
            }
        };
    }
}

