/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.audio;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public abstract class SoundLoop
implements ITickable {
    private static final Set<SoundLoop> activeLoops = new HashSet<SoundLoop>();
    private final ISound dummyStart;
    private final ISound start;
    private final ISound loop;
    private final ISound end;
    private boolean looping = false;
    private boolean needsRemoving = false;

    public SoundLoop(SoundEvent start, SoundEvent loop, SoundEvent end, SoundCategory category, float volume, ISoundFactory factory) {
        this.dummyStart = factory.create(start, category, 1.0E-5f, false);
        this.start = factory.create(start, category, volume, false);
        this.loop = factory.create(loop, category, volume, true);
        this.end = factory.create(end, category, volume, false);
    }

    public void func_73660_a() {
        if (!this.looping && !Minecraft.func_71410_x().func_147118_V().func_147692_c(this.dummyStart)) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a(this.loop);
            this.looping = true;
        }
    }

    public void endLoop() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a(this.end);
        this.markForRemoval();
    }

    protected void markForRemoval() {
        this.needsRemoving = true;
    }

    protected void stopStartAndLoop() {
        Minecraft.func_71410_x().func_147118_V().func_147683_b(this.dummyStart);
        Minecraft.func_71410_x().func_147118_V().func_147683_b(this.start);
        Minecraft.func_71410_x().func_147118_V().func_147683_b(this.loop);
    }

    public static void addLoop(SoundLoop loop) {
        activeLoops.add(loop);
        Minecraft.func_71410_x().func_147118_V().func_147682_a(loop.dummyStart);
        Minecraft.func_71410_x().func_147118_V().func_147681_a(loop.start, 2);
    }

    @SubscribeEvent
    public static void tick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            activeLoops.stream().filter(s -> s.needsRemoving).forEach(SoundLoop::stopStartAndLoop);
            activeLoops.removeIf(s -> s.needsRemoving);
            activeLoops.forEach(SoundLoop::func_73660_a);
        }
    }

    @FunctionalInterface
    public static interface ISoundFactory {
        public ISound create(SoundEvent var1, SoundCategory var2, float var3, boolean var4);
    }
}

