/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.gui;

import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.registry.WizardryTabs;
import electroblob.wizardry.spell.Spell;
import java.lang.reflect.Field;
import java.util.Locale;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class CustomCreativeSearchHandler {
    private static final int SEARCH_TOOLTIP_HOVER_TIME = 20;
    private static final Style TOOLTIP_SYNTAX = new Style().func_150238_a(TextFormatting.YELLOW);
    private static final Style TOOLTIP_BODY = new Style().func_150238_a(TextFormatting.WHITE);
    private static final Field searchField;
    private static GuiTextField currentSearchField;
    private static int searchBarHoverTime;

    @SubscribeEvent
    public static void onInitGuiEvent(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof GuiContainerCreative) {
            try {
                currentSearchField = (GuiTextField)searchField.get(event.getGui());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void onKeyboardInputEvent(GuiScreenEvent.KeyboardInputEvent.Post event) {
        GuiContainerCreative gui;
        CreativeTabs tab;
        if (event.getGui() instanceof GuiContainerCreative && (tab = CreativeTabs.field_78032_a[(gui = (GuiContainerCreative)event.getGui()).func_147056_g()]) == WizardryTabs.SPELLS) {
            GuiContainerCreative.ContainerCreative container = (GuiContainerCreative.ContainerCreative)gui.field_147002_h;
            container.field_148330_a.clear();
            String searchText = currentSearchField.func_146179_b().toLowerCase(Locale.ROOT);
            tab.func_78018_a(container.field_148330_a);
            if (!searchText.isEmpty()) {
                container.field_148330_a.removeIf(s -> !Spell.byMetadata(s.func_77960_j()).matches(searchText));
                container.func_148329_a(0.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && searchBarHoverTime > 0 && searchBarHoverTime < 20) {
            ++searchBarHoverTime;
        }
    }

    @SubscribeEvent
    public static void onDrawScreenPostEvent(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.getGui() instanceof GuiContainerCreative && currentSearchField != null) {
            GuiContainerCreative gui = (GuiContainerCreative)event.getGui();
            CreativeTabs tab = CreativeTabs.field_78032_a[gui.func_147056_g()];
            if (tab == WizardryTabs.SPELLS && DrawingUtils.isPointInRegion(CustomCreativeSearchHandler.currentSearchField.field_146209_f, CustomCreativeSearchHandler.currentSearchField.field_146210_g, CustomCreativeSearchHandler.currentSearchField.field_146218_h, CustomCreativeSearchHandler.currentSearchField.field_146219_i, event.getMouseX(), event.getMouseY())) {
                if (searchBarHoverTime == 0) {
                    ++searchBarHoverTime;
                } else if (searchBarHoverTime == 20) {
                    event.getGui().func_146279_a(I18n.func_135052_a((String)"container.ebwizardry:arcane_workbench.search_tooltip", (Object[])new Object[]{TOOLTIP_SYNTAX.func_150218_j(), TOOLTIP_BODY.func_150218_j()}), event.getMouseX(), event.getMouseY());
                }
            }
        } else {
            searchBarHoverTime = 0;
        }
    }

    static {
        currentSearchField = null;
        searchField = ObfuscationReflectionHelper.findField(GuiContainerCreative.class, (String)"field_147062_A");
    }
}

