/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.gui;

import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.packet.PacketControlInput;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Resurrection;
import electroblob.wizardry.util.InventoryUtils;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class GuiButtonResurrect
extends GuiButton {
    private static int timeSinceDeath = -1;
    private final String translationKey;

    public GuiButtonResurrect(int id, int x, int y, String translationKey) {
        super(id, x, y, I18n.func_135052_a((String)(translationKey + "_wait"), (Object[])new Object[]{Resurrection.getRemainingWaitTime(timeSinceDeath)}));
        this.translationKey = translationKey;
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        int waitTime = Resurrection.getRemainingWaitTime(timeSinceDeath);
        this.field_146124_l = waitTime == 0;
        this.field_146126_j = I18n.func_135052_a((String)(this.translationKey + (waitTime == 0 ? "_ready" : "_wait")), (Object[])new Object[]{waitTime});
        super.func_191745_a(mc, mouseX, mouseY, partialTicks);
    }

    @SubscribeEvent
    public static void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && timeSinceDeath >= 0) {
            ++timeSinceDeath;
        }
    }

    @SubscribeEvent
    public static void onGuiScreenInitEvent(GuiScreenEvent.InitGuiEvent event) {
        if (event.getGui() instanceof GuiGameOver && ItemArtefact.isArtefactActive((EntityPlayer)Minecraft.func_71410_x().field_71439_g, WizardryItems.amulet_resurrection) && InventoryUtils.getHotbar((EntityPlayer)Minecraft.func_71410_x().field_71439_g).stream().anyMatch(s -> Resurrection.canStackResurrect(s, (EntityPlayer)Minecraft.func_71410_x().field_71439_g))) {
            event.getButtonList().add(new GuiButtonResurrect(event.getButtonList().size(), event.getGui().field_146294_l / 2 - 100, event.getGui().field_146295_m / 4 + 120, "spell." + Spells.resurrection.getRegistryName() + ".button"));
            timeSinceDeath = 0;
        }
    }

    @SubscribeEvent
    public static void onGuiScreenActionPerformedEvent(GuiScreenEvent.ActionPerformedEvent event) {
        ItemStack stack;
        if (event.getGui() instanceof GuiGameOver && (stack = (ItemStack)InventoryUtils.getHotbar((EntityPlayer)Minecraft.func_71410_x().field_71439_g).stream().filter(s -> Resurrection.canStackResurrect(s, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)).findFirst().orElse(null)) != null) {
            if (event.getButton() instanceof GuiButtonResurrect && timeSinceDeath >= 0) {
                ((ISpellCastingItem)stack.func_77973_b()).cast(stack, Spells.resurrection, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, EnumHand.MAIN_HAND, 0, new SpellModifiers());
                WizardryPacketHandler.net.sendToServer((IMessage)new PacketControlInput.Message(PacketControlInput.ControlType.RESURRECT_BUTTON));
            } else if (!Minecraft.func_71410_x().field_71441_e.func_82736_K().func_82766_b("keepInventory")) {
                WizardryPacketHandler.net.sendToServer((IMessage)new PacketControlInput.Message(PacketControlInput.ControlType.CANCEL_RESURRECT));
            }
            timeSinceDeath = -1;
        }
    }
}

