/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.gui.handbook;

import com.google.common.collect.Streams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.client.gui.handbook.GuiWizardHandbook;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

class CraftingRecipe {
    static final int BORDER = 7;
    static final int TEXTURE_INSET_X = 40;
    static final int TEXTURE_INSET_Y = 190;
    static final int WIDTH = 121;
    static final int HEIGHT = 66;
    private final ResourceLocation[] locations;
    private List<IRecipe> recipes;
    private final Set<int[]> instances = new HashSet<int[]>();

    private CraftingRecipe(ResourceLocation[] locations) {
        this.locations = locations;
    }

    void addInstance(int page, int x, int y) {
        this.instances.add(new int[]{page, x, y});
    }

    void clearInstances() {
        this.instances.clear();
    }

    void load() {
        this.recipes = new ArrayList<IRecipe>(this.locations.length);
        for (ResourceLocation location : this.locations) {
            IRecipe recipe = CraftingManager.func_193373_a((ResourceLocation)location);
            if (recipe == null) {
                Wizardry.logger.warn("The recipe {} used in the wizard's handbook does not exist, it will display a blank grid instead", (Object)location);
                continue;
            }
            this.recipes.add(recipe);
        }
    }

    void draw(FontRenderer font, RenderItem itemRenderer, int doublePage, int left, int top) {
        int index = (int)(Minecraft.func_71386_F() % Integer.MAX_VALUE) / 2000;
        for (int[] instance : this.instances) {
            if (GuiWizardHandbook.singleToDoublePage(instance[0]) != doublePage) continue;
            CraftingRecipe.renderCraftingRecipe(font, itemRenderer, left + instance[1], top + instance[2], this.recipes.isEmpty() ? null : this.recipes.get(index % this.recipes.size()));
        }
    }

    void drawTooltips(GuiWizardHandbook gui, FontRenderer font, RenderItem itemRenderer, int doublePage, int left, int top, int mouseX, int mouseY) {
        if (this.recipes.isEmpty()) {
            return;
        }
        int index = (int)(Minecraft.func_71386_F() % Integer.MAX_VALUE) / 2000;
        for (int[] instance : this.instances) {
            if (GuiWizardHandbook.singleToDoublePage(instance[0]) != doublePage) continue;
            CraftingRecipe.renderCraftingTooltips(gui, itemRenderer, left + instance[1], top + instance[2], mouseX, mouseY, this.recipes.get(index % this.recipes.size()));
        }
    }

    static CraftingRecipe fromJson(JsonObject json) {
        ResourceLocation[] locations = (ResourceLocation[])Streams.stream((Iterable)JsonUtils.func_151214_t((JsonObject)json, (String)"locations")).map(je -> new ResourceLocation(je.getAsString())).toArray(ResourceLocation[]::new);
        return new CraftingRecipe(locations);
    }

    static void populate(Map<String, CraftingRecipe> map, JsonObject json) {
        JsonObject sectionsObject = JsonUtils.func_152754_s((JsonObject)json, (String)"recipes");
        for (Map.Entry entry : sectionsObject.entrySet()) {
            String key = (String)entry.getKey();
            CraftingRecipe recipe = CraftingRecipe.fromJson(((JsonElement)entry.getValue()).getAsJsonObject());
            map.put(key, recipe);
        }
    }

    private static void renderCraftingRecipe(FontRenderer font, RenderItem itemRenderer, int x, int y, @Nullable IRecipe recipe) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiWizardHandbook.texture);
        DrawingUtils.drawTexturedRect(x, y, 40, 190, 121, 66, 512, 256);
        if (recipe != null) {
            GlStateManager.func_179094_E();
            RenderHelper.func_74520_c();
            GlStateManager.func_179140_f();
            GlStateManager.func_179091_B();
            GlStateManager.func_179142_g();
            itemRenderer.field_77023_b = 100.0f;
            int index = (int)(Minecraft.func_71386_F() % Integer.MAX_VALUE) / 2000;
            int i = 0;
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ItemStack stack;
                if (ingredient != Ingredient.field_193370_a && !(stack = ingredient.func_193365_a()[index % ingredient.func_193365_a().length]).func_190926_b()) {
                    itemRenderer.func_180450_b(stack, x + 7 + 18 * (i % 3), y + 7 + 18 * (i / 3));
                    itemRenderer.func_175030_a(font, stack, x + 7 + 18 * (i % 3), y + 7 + 18 * (i / 3));
                }
                ++i;
            }
            ItemStack result = recipe.func_77571_b();
            if (!result.func_190926_b()) {
                itemRenderer.func_180450_b(result, x + 7 + 86, y + 7 + 18);
                itemRenderer.func_175030_a(font, result, x + 7 + 86, y + 7 + 18);
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179126_j();
            GlStateManager.func_179119_h();
            itemRenderer.field_77023_b = 0.0f;
            RenderHelper.func_74518_a();
        }
    }

    private static void renderCraftingTooltips(GuiWizardHandbook gui, RenderItem itemRenderer, int x, int y, int mouseX, int mouseY, IRecipe recipe) {
        ItemStack result = recipe.func_77571_b();
        GlStateManager.func_179094_E();
        RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        itemRenderer.field_77023_b = 0.0f;
        int index = (int)(Minecraft.func_71386_F() % Integer.MAX_VALUE) / 2000;
        int i = 0;
        for (Ingredient ingredient : recipe.func_192400_c()) {
            ItemStack stack;
            if (ingredient != Ingredient.field_193370_a && !(stack = ingredient.func_193365_a()[index % ingredient.func_193365_a().length]).func_190926_b() && CraftingRecipe.isPointInRegion(x + 7 + 18 * (i % 3), y + 7 + 18 * (i / 3), 16, 16, mouseX, mouseY)) {
                gui.func_146285_a(stack, mouseX, mouseY);
            }
            ++i;
        }
        if (!result.func_190926_b() && CraftingRecipe.isPointInRegion(x + 7 + 86, y + 7 + 18, 16, 16, mouseX, mouseY)) {
            gui.func_146285_a(result, mouseX, mouseY);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179126_j();
        GlStateManager.func_179119_h();
        RenderHelper.func_74518_a();
    }

    private static boolean isPointInRegion(int left, int top, int width, int height, int mouseX, int mouseY) {
        return mouseX >= left - 1 && mouseX < left + width + 1 && mouseY >= top - 1 && mouseY < top + height + 1;
    }
}

