/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.gui.handbook;

import com.google.gson.JsonSyntaxException;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.client.gui.handbook.GuiWizardHandbook;
import electroblob.wizardry.client.gui.handbook.Section;
import electroblob.wizardry.registry.WizardrySounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;

public abstract class GuiButtonHyperlink
extends GuiButton {
    public static final String URL_REGEX = "^((https?|ftp)://|(www|ftp)\\.)?[a-z0-9-]+(\\.[a-z0-9-]+)+([/?].*)?$";
    private static final float PULSATION_PERIOD = 1500.0f;
    final int indent;
    final List<String> lines;
    final int linesLeft;

    GuiButtonHyperlink(int id, int x, int y, FontRenderer font, String text, int indent, String suffix, int linesLeft, boolean rightPage, boolean spaceless) {
        super(id, x, y, font.func_78256_a(text), font.field_78288_b, text);
        String firstWord;
        String linkWithSuffix = text + suffix;
        String string = firstWord = spaceless ? linkWithSuffix.substring(0, 1) : linkWithSuffix.split("\\s")[0];
        if (font.func_78256_a(firstWord) > 120 - indent) {
            indent = 0;
            this.field_146129_i += font.field_78288_b;
        }
        this.indent = indent;
        this.linesLeft = linesLeft;
        String line1 = (String)font.func_78271_c(linkWithSuffix, 120 - indent).get(0);
        String remainder = linkWithSuffix.substring(line1.length()).trim();
        this.lines = new ArrayList<String>();
        this.lines.add(line1);
        if (!remainder.isEmpty()) {
            this.lines.addAll(font.func_78271_c(remainder, 120));
        }
        if (!suffix.isEmpty()) {
            for (int i = this.lines.size() - 1; i >= 0; --i) {
                String line = this.lines.get(i);
                if (suffix.endsWith(line)) {
                    this.lines.remove(i);
                    continue;
                }
                if (!line.endsWith(suffix)) continue;
                this.lines.set(i, line.substring(0, line.length() - suffix.length()));
                break;
            }
        }
        if (rightPage) {
            while (this.lines.size() > linesLeft) {
                this.lines.remove(this.lines.size() - 1);
            }
        }
    }

    public boolean isHovered(FontRenderer font, int mouseX, int mouseY) {
        int i = 0;
        for (String line : this.lines) {
            int l = this.field_146128_h;
            if (i == 0) {
                l += this.indent;
            }
            int t = this.field_146129_i + font.field_78288_b * i;
            if (i > this.linesLeft) {
                l = l + 288 - 34 - 120;
                t -= 140 - 140 % font.field_78288_b;
            }
            if (mouseX >= l && mouseY >= t && mouseX < l + font.func_78256_a(line) && mouseY < t + font.field_78288_b) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean func_146116_c(Minecraft minecraft, int mouseX, int mouseY) {
        return this.field_146124_l && this.field_146125_m && this.isHovered(minecraft.field_71466_p, mouseX, mouseY);
    }

    public void func_191745_a(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.field_146125_m) {
            this.field_146123_n = this.isHovered(minecraft.field_71466_p, mouseX, mouseY);
            int i = 0;
            for (String line : this.lines) {
                int l = this.field_146128_h;
                if (i == 0) {
                    l += this.indent;
                }
                int t = this.field_146129_i + minecraft.field_71466_p.field_78288_b * i;
                if (i > this.linesLeft) {
                    l = l + 288 - 34 - 120;
                    t -= 140 - 140 % minecraft.field_71466_p.field_78288_b;
                }
                minecraft.field_71466_p.func_78276_b(line, l, t, this.getColour());
                ++i;
            }
        }
    }

    protected int getColour() {
        return this.field_146123_n ? GuiWizardHandbook.colours.get("highlight").intValue() : GuiWizardHandbook.colours.get("hyperlink").intValue();
    }

    public static GuiButtonHyperlink create(int x, int y, FontRenderer font, List<String> upToLink, String[] arguments, String suffix, int linesLeft, boolean rightPage, boolean spaceless) {
        GuiButtonHyperlink button;
        if (arguments.length == 0 || arguments.length > 2) {
            throw new IllegalArgumentException("Incorrect array length!");
        }
        if (arguments[0].matches(URL_REGEX)) {
            button = new External(0, x, y, font, arguments[arguments.length - 1], arguments[0], font.func_78256_a(upToLink.get(upToLink.size() - 1)), suffix, linesLeft, rightPage, spaceless);
        } else {
            Section target = GuiWizardHandbook.sections.get(arguments[0]);
            if (target == null) {
                throw new JsonSyntaxException("Hyperlink points to nonexistent section id " + arguments[0]);
            }
            button = new Internal(0, x, y, font, arguments[arguments.length - 1], target, font.func_78256_a(upToLink.get(upToLink.size() - 1)), suffix, linesLeft, rightPage, spaceless);
        }
        return button;
    }

    static class External
    extends GuiButtonHyperlink {
        final ITextComponent link;

        External(int id, int x, int y, FontRenderer font, String text, String url, int indent, String suffix, int linesLeft, boolean rightPage, boolean spaceless) {
            super(id, x, y, font, text, indent, suffix, linesLeft, rightPage, spaceless);
            this.link = new TextComponentString(text);
            this.link.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, url)).func_150238_a(TextFormatting.DARK_BLUE);
        }
    }

    static class Internal
    extends GuiButtonHyperlink {
        final Section target;

        Internal(int id, int x, int y, FontRenderer font, String text, Section target, int indent, String suffix, int linesLeft, boolean rightPage, boolean spaceless) {
            super(id, x, y, font, text, indent, suffix, linesLeft, rightPage, spaceless);
            this.target = target;
        }

        @Override
        public boolean func_146116_c(Minecraft minecraft, int mouseX, int mouseY) {
            if (!this.target.isUnlocked()) {
                return false;
            }
            return super.func_146116_c(minecraft, mouseX, mouseY);
        }

        public void func_146113_a(SoundHandler soundHandler) {
            soundHandler.func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)WizardrySounds.MISC_PAGE_TURN, (float)1.0f));
        }

        @Override
        protected int getColour() {
            if (!this.target.isUnlocked()) {
                return GuiWizardHandbook.colours.get("text");
            }
            if (!this.field_146123_n && this.target.isNew() && !Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
                int c = GuiWizardHandbook.colours.get("new_section");
                int d = GuiWizardHandbook.colours.get("hyperlink");
                float f = (MathHelper.func_76126_a((float)((float)Minecraft.func_71386_F() % 1500.0f / 1500.0f * 2.0f * (float)Math.PI)) + 1.0f) / 2.0f;
                return DrawingUtils.mix(c, d, f);
            }
            return super.getColour();
        }
    }
}

