/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.block.BlockBookshelf;
import electroblob.wizardry.client.model.BakedModelBookshelf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;

public class ModelBookshelf
implements IModel {
    private static final List<ResourceLocation> bookModelLocations = new ArrayList<ResourceLocation>();
    private static final Map<String, IBakedModel[][]> bakedBookModels = new HashMap<String, IBakedModel[][]>();
    private final ModelResourceLocation bookshelfModelLocation;
    private final String variant;

    public ModelBookshelf(String bookshelfModelName) {
        String[] args = bookshelfModelName.split("#", 2);
        String model = args[0];
        this.variant = args.length == 2 ? args[1] : null;
        this.bookshelfModelLocation = new ModelResourceLocation(new ResourceLocation("ebwizardry", "bookshelf_parts/" + model), this.variant);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        try {
            IModel bookshelfModel = ModelLoaderRegistry.getModel((ResourceLocation)this.bookshelfModelLocation);
            IBakedModel bookshelf = bookshelfModel.bake(bookshelfModel.getDefaultState(), format, bakedTextureGetter);
            IBakedModel[][] books = this.getBakedBookModels(format, bakedTextureGetter);
            return new BakedModelBookshelf(bookshelf, books);
        }
        catch (Exception exception) {
            Wizardry.logger.error("Error baking bookshelf models: ", (Throwable)exception);
            return ModelLoaderRegistry.getMissingModel().bake(state, format, bakedTextureGetter);
        }
    }

    protected IBakedModel[][] getBakedBookModels(VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) throws Exception {
        if (bakedBookModels.get(this.variant) == null) {
            ImmutableList<ResourceLocation> textures = BlockBookshelf.getBookTextures();
            bakedBookModels.put(this.variant, new IBakedModel[textures.size()][12]);
            for (int i = 0; i < textures.size(); ++i) {
                ImmutableMap retexturer = ImmutableMap.of((Object)"books", (Object)((ResourceLocation)textures.get(i)).toString());
                for (int j = 0; j < 12; ++j) {
                    IModel bookModel = ModelLoaderRegistry.getModel((ResourceLocation)new ModelResourceLocation(bookModelLocations.get(j), this.variant)).retexture(retexturer);
                    ModelBookshelf.bakedBookModels.get((Object)this.variant)[i][j] = bookModel.bake(bookModel.getDefaultState(), format, bakedTextureGetter);
                }
            }
        }
        return bakedBookModels.get(this.variant);
    }

    public Collection<ResourceLocation> getDependencies() {
        return bookModelLocations;
    }

    public Collection<ResourceLocation> getTextures() {
        return BlockBookshelf.getBookTextures();
    }

    static {
        for (int i = 0; i < 12; ++i) {
            bookModelLocations.add(new ResourceLocation("ebwizardry", "bookshelf_parts/books" + i));
        }
    }
}

