/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.data;

import electroblob.wizardry.data.Persistence;
import io.netty.buffer.ByteBuf;
import java.util.function.BiFunction;
import net.minecraft.entity.player.EntityPlayer;

public interface IVariable<T> {
    public T update(EntityPlayer var1, T var2);

    public boolean isPersistent(boolean var1);

    public boolean isSynced();

    public void write(ByteBuf var1, T var2);

    public T read(ByteBuf var1);

    default public boolean canPurge(EntityPlayer player, T value) {
        return false;
    }

    public static class Variable<T>
    implements IVariable<T> {
        private final Persistence persistence;
        private BiFunction<EntityPlayer, T, T> ticker;

        public Variable(Persistence persistence) {
            this.persistence = persistence;
            this.ticker = (p, t) -> t;
        }

        public Variable<T> withTicker(BiFunction<EntityPlayer, T, T> ticker) {
            this.ticker = ticker;
            return this;
        }

        @Override
        public T update(EntityPlayer player, T value) {
            return this.ticker.apply(player, (EntityPlayer)value);
        }

        @Override
        public boolean isPersistent(boolean respawn) {
            return respawn ? this.persistence.persistsOnRespawn() : this.persistence.persistsOnDimensionChange();
        }

        @Override
        public boolean isSynced() {
            return false;
        }

        @Override
        public void write(ByteBuf buf, T value) {
        }

        @Override
        public T read(ByteBuf buf) {
            return null;
        }
    }
}

