/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.construct;

import electroblob.wizardry.entity.ICustomHitbox;
import electroblob.wizardry.entity.construct.EntityMagicConstruct;
import electroblob.wizardry.entity.construct.EntityScaledConstruct;
import electroblob.wizardry.registry.WizardrySounds;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityIceBarrier
extends EntityScaledConstruct
implements ICustomHitbox {
    private static final double THICKNESS = 0.4;
    private int delay = 0;

    public EntityIceBarrier(World world) {
        super(world);
        this.func_70105_a(1.8f, 1.05f);
    }

    public void setDelay(int delay) {
        this.delay = delay;
        this.lifetime += delay;
    }

    public void func_70101_b(float yaw, float pitch) {
        super.func_70101_b(yaw, pitch);
        float a = MathHelper.func_76134_b((float)((float)Math.toRadians(this.field_70177_z)));
        float b = MathHelper.func_76126_a((float)((float)Math.toRadians(this.field_70177_z)));
        double x = (double)(this.field_70130_N / 2.0f * a) + 0.2 * (double)b;
        double z = (double)(this.field_70130_N / 2.0f * b) + 0.2 * (double)a;
        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - x, this.field_70163_u, this.field_70161_v - z, this.field_70165_t + x, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v + z));
    }

    public boolean func_70067_L() {
        return true;
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K && this.field_70148_d) {
            this.setSizeMultiplier(this.sizeMultiplier);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.field_70170_p.field_72995_K) {
            double extensionSpeed = 0.0;
            if (this.lifetime - this.field_70173_aa < 20) {
                extensionSpeed = -0.01 * (double)(this.field_70173_aa - (this.lifetime - 20)) * (double)this.sizeMultiplier;
            } else if (this.field_70173_aa > 3 + this.delay) {
                extensionSpeed = 0.0;
            } else if (this.field_70173_aa > this.delay) {
                extensionSpeed = 0.5 * (double)this.sizeMultiplier;
            }
            this.func_70091_d(MoverType.SELF, 0.0, extensionSpeed, 0.0);
        }
        if (this.field_70173_aa == this.delay + 1) {
            this.func_184185_a(WizardrySounds.ENTITY_ICE_BARRIER_EXTEND, 1.0f, 1.5f);
        }
        super.func_70071_h_();
        Vec3d look = this.func_70040_Z();
        if (!this.field_70170_p.field_72995_K) {
            for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_186662_g(2.0))) {
                double perpendicularDist;
                if (entity instanceof EntityMagicConstruct || !entity.func_174813_aQ().func_72326_a(this.func_174813_aQ()) || !(Math.abs(perpendicularDist = this.getSignedPerpendicularDistance(entity.func_174791_d().func_72441_c(1.0, 0.0, 1.0))) < (double)(entity.field_70130_N / 2.0f) + 0.2)) continue;
                double velocity = 0.25 * Math.signum(perpendicularDist);
                entity.func_70024_g(velocity * look.field_72450_a, 0.0, velocity * look.field_72449_c);
                if (!(entity instanceof EntityPlayerMP)) continue;
                ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(entity));
            }
        }
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        this.func_184185_a(WizardrySounds.ENTITY_ICE_BARRIER_DEFLECT, 0.7f, 2.5f);
        return super.func_70097_a(source, amount);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.delay = nbt.func_74762_e("delay");
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("delay", this.delay);
    }

    @Override
    public Vec3d calculateIntercept(Vec3d origin, Vec3d endpoint, float fuzziness) {
        Vec3d vec = endpoint.func_178788_d(origin);
        double perpendicularDist = this.getPerpendicularDistance(origin);
        double perpendicularDist2 = this.getPerpendicularDistance(endpoint);
        Vec3d intercept = origin.func_178787_e(vec.func_186678_a(perpendicularDist / (perpendicularDist + perpendicularDist2)));
        return this.func_174813_aQ().func_186662_g((double)fuzziness).func_72318_a(intercept) ? intercept : null;
    }

    @Override
    public boolean contains(Vec3d point) {
        return this.func_174813_aQ().func_72318_a(point) && this.getPerpendicularDistance(point) < 0.2;
    }

    private double getPerpendicularDistance(Vec3d point) {
        return Math.abs(this.getSignedPerpendicularDistance(point));
    }

    private double getSignedPerpendicularDistance(Vec3d point) {
        Vec3d look = this.func_70040_Z();
        Vec3d delta = new Vec3d(point.field_72450_a - this.field_70165_t, 0.0, point.field_72449_c - this.field_70161_v);
        return delta.func_72430_b(look);
    }
}

