/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.integration.jei;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.integration.jei.ImbuementAltarRecipe;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.tileentity.TileEntityImbuementAltar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class ImbuementAltarRecipeCategory
implements IRecipeCategory<ImbuementAltarRecipe> {
    static final String UID = "ebwizardry:imbuement_altar";
    static final ResourceLocation TEXTURE = new ResourceLocation("ebwizardry", "textures/integration/jei/imbuement_altar_background.png");
    static final int WIDTH = 134;
    static final int HEIGHT = 74;
    static final int CENTRE_SLOT_X = 28;
    static final int CENTRE_SLOT_Y = 28;
    static final int SLOT_SPACING_X = 28;
    static final int SLOT_SPACING_Y = 28;
    static final int OUTPUT_SLOT_X = 112;
    static final int OUTPUT_SLOT_Y = 28;
    private final IDrawable background;

    public ImbuementAltarRecipeCategory(IRecipeCategoryRegistration registry) {
        IGuiHelper helper = registry.getJeiHelpers().getGuiHelper();
        this.background = helper.createDrawable(TEXTURE, 0, 0, 134, 74);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"integration.jei.category.ebwizardry:imbuement_altar", (Object[])new Object[0]);
    }

    public String getModName() {
        return "Electroblob's Wizardry";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, ImbuementAltarRecipe recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup slots = recipeLayout.getItemStacks();
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        int i = 0;
        slots.init(i++, true, 28, 28);
        slots.init(i++, true, 28, 0);
        slots.init(i++, true, 0, 28);
        slots.init(i++, true, 28, 56);
        slots.init(i++, true, 56, 28);
        slots.init(i++, false, 112, 28);
        for (int j = 0; j < inputs.size(); ++j) {
            slots.set(j, (List)inputs.get(j));
        }
        for (int k = 0; k < outputs.size(); ++k) {
            slots.set(inputs.size() + k, (List)outputs.get(k));
        }
    }

    public static Collection<ImbuementAltarRecipe> generateRecipes() {
        ArrayList<ImbuementAltarRecipe> recipes = new ArrayList<ImbuementAltarRecipe>();
        recipes.addAll(ImbuementAltarRecipeCategory.generateBookRecipes());
        recipes.addAll(ImbuementAltarRecipeCategory.generateCrystalRecipes());
        recipes.addAll(ImbuementAltarRecipeCategory.generateCrystalBlockRecipes());
        recipes.addAll(ImbuementAltarRecipeCategory.generateArmourRecipes());
        return recipes;
    }

    private static Collection<ImbuementAltarRecipe> generateBookRecipes() {
        ArrayList<ImbuementAltarRecipe> recipes = new ArrayList<ImbuementAltarRecipe>();
        NonNullList variants = NonNullList.func_191196_a();
        WizardryItems.spectral_dust.func_150895_a(WizardryItems.spectral_dust.func_77640_w(), variants);
        ArrayList<List<ItemStack>> dusts = new ArrayList<List<ItemStack>>();
        for (int i = 0; i < 4; ++i) {
            Collections.shuffle(variants);
            dusts.add(new ArrayList(variants));
        }
        recipes.add(new ImbuementAltarRecipe(new ItemStack(WizardryItems.ruined_spell_book), dusts, new ItemStack(WizardryItems.spell_book, 1, Short.MAX_VALUE)));
        return recipes;
    }

    private static Collection<ImbuementAltarRecipe> generateCrystalRecipes() {
        ArrayList<ImbuementAltarRecipe> recipes = new ArrayList<ImbuementAltarRecipe>();
        ItemStack input = new ItemStack(WizardryItems.magic_crystal);
        for (int meta = 1; meta < Element.values().length; ++meta) {
            List<List<ItemStack>> dusts = Collections.nCopies(4, Collections.singletonList(new ItemStack(WizardryItems.spectral_dust, 1, meta)));
            ItemStack output = new ItemStack(WizardryItems.magic_crystal, 1, meta);
            recipes.add(new ImbuementAltarRecipe(input, dusts, output));
        }
        return recipes;
    }

    private static Collection<ImbuementAltarRecipe> generateCrystalBlockRecipes() {
        ArrayList<ImbuementAltarRecipe> recipes = new ArrayList<ImbuementAltarRecipe>();
        ItemStack input = new ItemStack(WizardryBlocks.crystal_block);
        for (int meta = 1; meta < Element.values().length; ++meta) {
            List<List<ItemStack>> dusts = Collections.nCopies(4, Collections.singletonList(new ItemStack(WizardryItems.spectral_dust, 1, meta)));
            ItemStack output = new ItemStack(WizardryBlocks.crystal_block, 1, meta);
            recipes.add(new ImbuementAltarRecipe(input, dusts, output));
        }
        return recipes;
    }

    private static Collection<ImbuementAltarRecipe> generateArmourRecipes() {
        ArrayList<ImbuementAltarRecipe> recipes = new ArrayList<ImbuementAltarRecipe>();
        for (Item item : Item.field_150901_e) {
            if (!(item instanceof ItemWizardArmour)) continue;
            ItemStack input = new ItemStack(item);
            for (Element e : Element.values()) {
                if (e == Element.MAGIC) continue;
                List<List<ItemStack>> dusts = Collections.nCopies(4, Collections.singletonList(new ItemStack(WizardryItems.spectral_dust, 1, e.ordinal())));
                ItemStack output = TileEntityImbuementAltar.getImbuementResult(input, new Element[]{e, e, e, e}, false, null, null);
                if (output.func_190926_b()) continue;
                recipes.add(new ImbuementAltarRecipe(input, dusts, output));
            }
        }
        return recipes;
    }
}

