/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.packet;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketDispenserCastSpell
implements IMessageHandler<Message, IMessage> {
    public IMessage onMessage(Message message, MessageContext ctx) {
        if (ctx.side.isClient()) {
            Minecraft.func_71410_x().func_152344_a(() -> Wizardry.proxy.handleDispenserCastSpellPacket(message));
        }
        return null;
    }

    public static class Message
    implements IMessage {
        public int spellID;
        public double x;
        public double y;
        public double z;
        public EnumFacing direction;
        public BlockPos pos;
        public int duration;
        public SpellModifiers modifiers;

        public Message() {
        }

        public Message(double x, double y, double z, EnumFacing direction, BlockPos pos, Spell spell, int duration, SpellModifiers modifiers) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.direction = direction;
            this.pos = pos;
            this.spellID = spell.networkID();
            this.duration = duration;
            this.modifiers = modifiers;
        }

        public void fromBytes(ByteBuf buf) {
            this.x = buf.readDouble();
            this.y = buf.readDouble();
            this.z = buf.readDouble();
            this.direction = EnumFacing.values()[buf.readInt()];
            this.pos = BlockPos.func_177969_a((long)buf.readLong());
            this.spellID = buf.readInt();
            this.duration = buf.readInt();
            this.modifiers = new SpellModifiers();
            this.modifiers.read(buf);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeDouble(this.x);
            buf.writeDouble(this.y);
            buf.writeDouble(this.z);
            buf.writeInt(this.direction.ordinal());
            buf.writeLong(this.pos.func_177986_g());
            buf.writeInt(this.spellID);
            buf.writeInt(this.duration);
            this.modifiers.write(buf);
        }
    }
}

