/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class ChainLightning
extends SpellRay {
    public static final String PRIMARY_DAMAGE = "primary_damage";
    public static final String SECONDARY_DAMAGE = "secondary_damage";
    public static final String TERTIARY_DAMAGE = "tertiary_damage";
    public static final String SECONDARY_RANGE = "secondary_range";
    public static final String TERTIARY_RANGE = "tertiary_range";
    public static final String SECONDARY_MAX_TARGETS = "secondary_max_targets";
    public static final String TERTIARY_MAX_TARGETS = "tertiary_max_targets";

    public ChainLightning() {
        super("chain_lightning", SpellActions.POINT, false);
        this.aimAssist(0.6f);
        this.soundValues(1.0f, 1.7f, 0.2f);
        this.addProperties(PRIMARY_DAMAGE, SECONDARY_DAMAGE, TERTIARY_DAMAGE, SECONDARY_RANGE, TERTIARY_RANGE, SECONDARY_MAX_TARGETS, TERTIARY_MAX_TARGETS);
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (EntityUtils.isLiving(target)) {
            this.electrocute(world, (Entity)caster, origin, target, this.getProperty(PRIMARY_DAMAGE).floatValue() * modifiers.get("potency"));
            List<EntityLivingBase> secondaryTargets = EntityUtils.getLivingWithinRadius(this.getProperty(SECONDARY_RANGE).doubleValue(), target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v, world);
            secondaryTargets.remove(target);
            secondaryTargets.removeIf(e -> !EntityUtils.isLiving((Entity)e));
            secondaryTargets.removeIf(e -> !AllyDesignationSystem.isValidTarget((Entity)caster, (Entity)e));
            if (secondaryTargets.size() > this.getProperty(SECONDARY_MAX_TARGETS).intValue()) {
                secondaryTargets = secondaryTargets.subList(0, this.getProperty(SECONDARY_MAX_TARGETS).intValue());
            }
            for (EntityLivingBase secondaryTarget : secondaryTargets) {
                this.electrocute(world, (Entity)caster, target.func_174791_d().func_72441_c(0.0, (double)(target.field_70131_O / 2.0f), 0.0), (Entity)secondaryTarget, this.getProperty(SECONDARY_DAMAGE).floatValue() * modifiers.get("potency"));
                List<EntityLivingBase> tertiaryTargets = EntityUtils.getLivingWithinRadius(this.getProperty(TERTIARY_RANGE).doubleValue(), secondaryTarget.field_70165_t, secondaryTarget.field_70163_u + (double)(secondaryTarget.field_70131_O / 2.0f), secondaryTarget.field_70161_v, world);
                tertiaryTargets.remove(target);
                tertiaryTargets.removeAll(secondaryTargets);
                tertiaryTargets.removeIf(e -> !EntityUtils.isLiving((Entity)e));
                tertiaryTargets.removeIf(e -> !AllyDesignationSystem.isValidTarget((Entity)caster, (Entity)e));
                if (tertiaryTargets.size() > this.getProperty(TERTIARY_MAX_TARGETS).intValue()) {
                    tertiaryTargets = tertiaryTargets.subList(0, this.getProperty(TERTIARY_MAX_TARGETS).intValue());
                }
                for (EntityLivingBase tertiaryTarget : tertiaryTargets) {
                    this.electrocute(world, (Entity)caster, secondaryTarget.func_174791_d().func_72441_c(0.0, (double)(secondaryTarget.field_70131_O / 2.0f), 0.0), (Entity)tertiaryTarget, this.getProperty(TERTIARY_DAMAGE).floatValue() * modifiers.get("potency"));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    private void electrocute(World world, Entity caster, Vec3d origin, Entity target, float damage) {
        if (MagicDamage.isEntityImmune(MagicDamage.DamageType.SHOCK, target)) {
            if (!world.field_72995_K && caster instanceof EntityPlayer) {
                ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}), true);
            }
        } else {
            target.func_70097_a(MagicDamage.causeDirectMagicDamage(caster, MagicDamage.DamageType.SHOCK), damage);
        }
        if (world.field_72995_K) {
            ParticleBuilder.create(ParticleBuilder.Type.LIGHTNING).entity(caster).pos(caster != null ? origin.func_178788_d(caster.func_174791_d()) : origin).target(target).spawn(world);
            ParticleBuilder.spawnShockParticles(world, target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v);
        }
    }
}

