/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import com.google.common.collect.ImmutableMap;
import electroblob.wizardry.item.IConjuredItem;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellConjuration;
import electroblob.wizardry.util.InventoryUtils;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;

public class ConjureArmour
extends SpellConjuration {
    private static final Map<EntityEquipmentSlot, Item> SPECTRAL_ARMOUR_MAP = ImmutableMap.of((Object)EntityEquipmentSlot.HEAD, (Object)WizardryItems.spectral_helmet, (Object)EntityEquipmentSlot.CHEST, (Object)WizardryItems.spectral_chestplate, (Object)EntityEquipmentSlot.LEGS, (Object)WizardryItems.spectral_leggings, (Object)EntityEquipmentSlot.FEET, (Object)WizardryItems.spectral_boots);

    public ConjureArmour() {
        super("conjure_armour", null);
    }

    @Override
    protected boolean conjureItem(EntityPlayer caster, SpellModifiers modifiers) {
        boolean flag = false;
        for (EntityEquipmentSlot slot : InventoryUtils.ARMOUR_SLOTS) {
            if (!caster.func_184582_a(slot).func_190926_b() || InventoryUtils.doesPlayerHaveItem(caster, SPECTRAL_ARMOUR_MAP.get(slot))) continue;
            ItemStack armour = new ItemStack(SPECTRAL_ARMOUR_MAP.get(slot));
            IConjuredItem.setDurationMultiplier(armour, modifiers.get(WizardryItems.duration_upgrade));
            NBTExtras.storeTagSafely(armour.func_77978_p(), "ench", (NBTBase)new NBTTagList());
            caster.func_184201_a(slot, armour);
            flag = true;
        }
        return flag;
    }
}

