/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Detonate
extends SpellRay {
    public static final String MAX_DAMAGE = "max_damage";

    public Detonate() {
        super("detonate", SpellActions.POINT, false);
        this.soundValues(4.0f, 0.7f, 0.14f);
        this.ignoreLivingEntities(true);
        this.addProperties(MAX_DAMAGE, "blast_radius");
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            List<EntityLivingBase> targets = EntityUtils.getLivingWithinRadius(this.getProperty("blast_radius").doubleValue() * (double)modifiers.get(WizardryItems.blast_upgrade), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), world);
            for (EntityLivingBase target : targets) {
                target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.BLAST), Math.max(this.getProperty(MAX_DAMAGE).floatValue() - (float)target.func_70011_f((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) * 4.0f, 0.0f) * modifiers.get("potency"));
            }
        } else {
            world.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
        }
        return true;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        world.func_175688_a(EnumParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0, new int[0]);
    }
}

