/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.data.IVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.RayTracer;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Grapple
extends Spell {
    public static final String EXTENSION_SPEED = "extension_speed";
    public static final String REEL_SPEED = "reel_speed";
    public static final IVariable<RayTraceResult> TARGET_KEY = new IVariable.Variable<RayTraceResult>(Persistence.NEVER).withTicker(Grapple::update);
    private static final double MINIMUM_REEL_DISTANCE = 3.0;
    private static final double REEL_ACCELERATION = 0.3;
    private static final double PAYOUT_SPEED = 0.25;
    private static final double STRETCH_LIMIT = 1.5;
    protected static final double PARTICLE_SPACING = 1.5;
    protected static final double PARTICLE_JITTER = 0.04;

    public Grapple() {
        super("grapple", SpellActions.GRAPPLE, true);
        this.addProperties("range", EXTENSION_SPEED, REEL_SPEED);
    }

    @Override
    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return true;
    }

    @Override
    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return true;
    }

    @Override
    protected SoundEvent[] createSounds() {
        return this.createSoundsWithSuffixes("shoot", "attach", "pull", "release");
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        boolean extending;
        WizardData data = WizardData.get(caster);
        Vec3d origin = caster.func_174824_e(1.0f);
        float extensionSpeed = this.getProperty(EXTENSION_SPEED).floatValue() * modifiers.get("potency");
        RayTraceResult hit = data.getVariable(TARGET_KEY);
        if (hit == null) {
            hit = this.findTarget(world, (EntityLivingBase)caster, origin, caster.func_70040_Z(), modifiers);
            data.setVariable(TARGET_KEY, hit);
            caster.func_184609_a(hand);
            if (hit.field_72313_a != RayTraceResult.Type.MISS || (float)ticksInUse * extensionSpeed < this.getProperty("range").floatValue() * modifiers.get(WizardryItems.range_upgrade)) {
                this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, "shoot");
            }
        }
        Vec3d target = hit.field_72307_f;
        if (hit.field_72308_g instanceof EntityLivingBase) {
            target = GeometryUtils.getCentre(hit.field_72308_g);
        }
        double distance = origin.func_72438_d(target);
        Vec3d direction = target.func_178788_d(origin).func_72432_b();
        double maxLength = (double)(this.getProperty("range").floatValue() * modifiers.get(WizardryItems.range_upgrade)) * 1.5;
        if (distance > maxLength) {
            if (world.field_72995_K && (double)((float)(ticksInUse - 1) * extensionSpeed) < distance) {
                this.spawnLeafParticles(world, origin.func_178786_a(0.0, 0.25, 0.0), direction, distance);
            }
            data.setVariable(TARGET_KEY, null);
            return false;
        }
        boolean bl = extending = (double)((float)ticksInUse * extensionSpeed) < distance;
        if (extending) {
            if (world.field_72995_K) {
                ParticleBuilder.create(ParticleBuilder.Type.VINE).entity((Entity)caster).pos(0.0, (double)caster.func_70047_e() - 0.25, 0.0).target(origin.func_178787_e(direction.func_186678_a((double)((float)ticksInUse * extensionSpeed)))).tvel(direction.func_186678_a((double)extensionSpeed)).seed(world.func_82737_E() - (long)ticksInUse).spawn(world);
            }
        } else {
            Vec3d velocity = direction.func_186678_a((double)(this.getProperty(REEL_SPEED).floatValue() * modifiers.get("potency")));
            int retractTime = ticksInUse - (int)(distance / (double)extensionSpeed);
            switch (hit.field_72313_a) {
                case BLOCK: {
                    if (caster.func_70093_af() && ItemArtefact.isArtefactActive(caster, WizardryItems.charm_abseiling)) {
                        velocity = new Vec3d(velocity.field_72450_a, distance < maxLength - 1.0 ? -0.25 : distance - maxLength + 1.0, velocity.field_72449_c);
                    }
                    double ax = (velocity.field_72450_a - caster.field_70159_w) * 0.3;
                    double ay = (velocity.field_72448_b - caster.field_70181_x) * 0.3;
                    double az = (velocity.field_72449_c - caster.field_70179_y) * 0.3;
                    caster.func_70024_g(ax, ay, az);
                    if (caster.field_70181_x > 0.0 && !Wizardry.settings.replaceVanillaFallDamage) {
                        caster.field_70143_R = 0.0f;
                    }
                    if (world.field_72995_K) {
                        ParticleBuilder.create(ParticleBuilder.Type.VINE).entity((Entity)caster).pos(0.0, (double)caster.func_70047_e() - 0.25, 0.0).target(target).seed(world.func_82737_E() - (long)ticksInUse).spawn(world);
                    }
                    if (retractTime != 1) break;
                    this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, "pull");
                    this.playSound(world, hit.field_72307_f, ticksInUse, -1, modifiers, "attach");
                    break;
                }
                case ENTITY: {
                    if (caster.func_70093_af() && ItemArtefact.isArtefactActive(caster, WizardryItems.charm_abseiling)) {
                        velocity = new Vec3d(velocity.field_72450_a, distance < maxLength - 1.0 ? 0.25 : maxLength - 1.0 - distance, velocity.field_72449_c);
                    }
                    Entity entity = hit.field_72308_g;
                    if (distance > 3.0) {
                        double ax1 = (-velocity.field_72450_a - entity.field_70159_w) * 0.3;
                        double ay1 = (-velocity.field_72448_b - entity.field_70181_x) * 0.3;
                        double az1 = (-velocity.field_72449_c - entity.field_70179_y) * 0.3;
                        entity.func_70024_g(ax1, ay1, az1);
                        if (entity instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(entity));
                        }
                    }
                    if (world.field_72995_K) {
                        ParticleBuilder.create(ParticleBuilder.Type.VINE).entity((Entity)caster).pos(0.0, (double)caster.func_70047_e() - 0.25, 0.0).target(entity).seed(world.func_82737_E() - (long)ticksInUse).spawn(world);
                    }
                    if (retractTime != 1) break;
                    this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, "pull");
                    this.playSound(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, ticksInUse, -1, modifiers, "attach");
                    break;
                }
                default: {
                    if (world.field_72995_K && (double)((float)(ticksInUse - 1) * extensionSpeed) < distance) {
                        this.spawnLeafParticles(world, origin.func_178786_a(0.0, 0.25, 0.0), direction, distance);
                    }
                    data.setVariable(TARGET_KEY, null);
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        Vec3d hookPosition;
        if (target == null) {
            return false;
        }
        Vec3d origin = caster.func_174824_e(1.0f);
        Vec3d targetVec = GeometryUtils.getCentre((Entity)target);
        RayTraceResult hit = this.findTarget(world, (EntityLivingBase)caster, origin, targetVec.func_178788_d(origin).func_72432_b(), modifiers);
        if (hit.field_72313_a != RayTraceResult.Type.ENTITY || hit.field_72308_g != target) {
            return false;
        }
        double distance = origin.func_72438_d(targetVec);
        if (ticksInUse <= 1 && distance > (double)(this.getProperty("range").floatValue() * modifiers.get(WizardryItems.range_upgrade))) {
            return false;
        }
        Vec3d vec = targetVec.func_178788_d(origin).func_72432_b();
        float extensionSpeed = this.getProperty(EXTENSION_SPEED).floatValue() * modifiers.get("potency");
        if (distance > (double)(this.getProperty("range").floatValue() * modifiers.get(WizardryItems.range_upgrade)) * 1.5) {
            if (world.field_72995_K && (double)((float)(ticksInUse - 1) * extensionSpeed) < distance) {
                this.spawnLeafParticles(world, origin.func_178786_a(0.0, 0.25, 0.0), vec, distance);
            }
            return false;
        }
        if ((double)((float)ticksInUse * extensionSpeed) < distance) {
            hookPosition = origin.func_178787_e(vec.func_186678_a((double)((float)ticksInUse * extensionSpeed)));
        } else {
            Vec3d velocity = vec.func_186678_a((double)(this.getProperty(REEL_SPEED).floatValue() * modifiers.get("potency")));
            if (distance > 3.0) {
                double ax1 = (-velocity.field_72450_a - target.field_70159_w) * 0.3;
                double ay1 = (-velocity.field_72448_b - target.field_70181_x) * 0.3;
                double az1 = (-velocity.field_72449_c - target.field_70179_y) * 0.3;
                target.func_70024_g(ax1, ay1, az1);
                if (target instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)target));
                }
            }
            hookPosition = targetVec;
        }
        if (world.field_72995_K) {
            ParticleBuilder.create(ParticleBuilder.Type.VINE).pos(origin).target(hookPosition).tvel(vec.func_186678_a((double)extensionSpeed)).seed(world.func_82737_E() - (long)ticksInUse).spawn(world);
        }
        return true;
    }

    @Override
    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        Vec3d origin = new Vec3d(x, y, z);
        RayTraceResult result = this.findTarget(world, null, origin, new Vec3d(direction.func_176730_m()), modifiers);
        if (result.field_72308_g instanceof EntityLivingBase) {
            Vec3d hookPosition;
            Entity entity = result.field_72308_g;
            Vec3d target = GeometryUtils.getCentre(entity);
            double distance = origin.func_72438_d(target);
            Vec3d vec = target.func_178788_d(origin).func_72432_b();
            float extensionSpeed = this.getProperty(EXTENSION_SPEED).floatValue() * modifiers.get("potency");
            if (distance > (double)(this.getProperty("range").floatValue() * modifiers.get(WizardryItems.range_upgrade)) * 1.5) {
                if (world.field_72995_K && (double)((float)(ticksInUse - 1) * extensionSpeed) < distance) {
                    this.spawnLeafParticles(world, origin.func_178786_a(0.0, 0.25, 0.0), vec, distance);
                }
                return false;
            }
            if ((double)((float)ticksInUse * extensionSpeed) < distance) {
                hookPosition = origin.func_178787_e(vec.func_186678_a((double)((float)ticksInUse * extensionSpeed)));
            } else {
                Vec3d velocity = vec.func_186678_a((double)(this.getProperty(REEL_SPEED).floatValue() * modifiers.get("potency")));
                if (distance > 3.0) {
                    double ax1 = (-velocity.field_72450_a - entity.field_70159_w) * 0.3;
                    double ay1 = (-velocity.field_72448_b - entity.field_70181_x) * 0.3;
                    double az1 = (-velocity.field_72449_c - entity.field_70179_y) * 0.3;
                    entity.func_70024_g(ax1, ay1, az1);
                    if (entity instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(entity));
                    }
                }
                hookPosition = target;
            }
            if (world.field_72995_K) {
                ParticleBuilder.create(ParticleBuilder.Type.VINE).pos(origin).target(hookPosition).seed(world.func_82737_E() - (long)ticksInUse).spawn(world);
            }
            return true;
        }
        return false;
    }

    @Override
    public void finishCasting(World world, @Nullable EntityLivingBase caster, double x, double y, double z, EnumFacing facing, int duration, SpellModifiers modifiers) {
        Vec3d origin = null;
        Vec3d direction = null;
        Vec3d target = null;
        if (caster != null) {
            EntityLivingBase entity;
            origin = caster.func_174824_e(1.0f);
            if (caster instanceof EntityPlayer) {
                RayTraceResult hit;
                WizardData data = WizardData.get((EntityPlayer)caster);
                if (data != null && (hit = data.getVariable(TARGET_KEY)) != null) {
                    target = hit.field_72307_f;
                }
            } else if (caster instanceof EntityLiving && (entity = ((EntityLiving)caster).func_70638_az()) != null) {
                target = GeometryUtils.getCentre((Entity)entity);
            }
            if (target != null) {
                direction = target.func_178788_d(origin).func_72432_b();
            }
            this.playSound(world, caster, duration, duration, modifiers, "release");
        } else if (!(Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(z))) {
            origin = new Vec3d(x, y, z);
            direction = new Vec3d(facing.func_176730_m());
            RayTraceResult result = this.findTarget(world, null, origin, direction, modifiers);
            target = result.field_72307_f;
            this.playSound(world, origin, duration, duration, modifiers, "release");
        }
        if (world.field_72995_K && origin != null && direction != null) {
            float extensionSpeed = this.getProperty(EXTENSION_SPEED).floatValue() * modifiers.get("potency");
            double distance = Math.min(target.func_178788_d(origin).func_72433_c(), (double)((float)duration * extensionSpeed));
            this.spawnLeafParticles(world, origin, direction, distance);
        }
    }

    private void spawnLeafParticles(World world, Vec3d origin, Vec3d direction, double distance) {
        for (double d = 1.5; d <= distance; d += 1.5) {
            double x = origin.field_72450_a + d * direction.field_72450_a;
            double y = origin.field_72448_b + d * direction.field_72448_b;
            double z = origin.field_72449_c + d * direction.field_72449_c;
            ParticleBuilder.create(ParticleBuilder.Type.LEAF, world.field_73012_v, x, y, z, 0.04, true).time(25 + world.field_73012_v.nextInt(5)).spawn(world);
        }
    }

    private RayTraceResult findTarget(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, SpellModifiers modifiers) {
        double range = this.getProperty("range").floatValue() * modifiers.get(WizardryItems.range_upgrade);
        Vec3d endpoint = origin.func_178787_e(direction.func_186678_a(range));
        RayTraceResult result = RayTracer.rayTrace(world, origin, endpoint, 0.0f, false, true, false, Entity.class, RayTracer.ignoreEntityFilter((Entity)caster));
        if (result == null || result.field_72313_a == RayTraceResult.Type.BLOCK && !world.func_180495_p(result.func_178782_a()).func_185904_a().func_76220_a()) {
            return new RayTraceResult(RayTraceResult.Type.MISS, endpoint, EnumFacing.DOWN, new BlockPos(endpoint));
        }
        if (result.field_72308_g != null && !result.field_72308_g.func_70104_M()) {
            return new RayTraceResult(RayTraceResult.Type.MISS, result.field_72307_f, EnumFacing.DOWN, new BlockPos(endpoint));
        }
        return result;
    }

    private static RayTraceResult update(EntityPlayer player, RayTraceResult grapplingTarget) {
        if (grapplingTarget != null && (!EntityUtils.isCasting((EntityLivingBase)player, Spells.grapple) || grapplingTarget.field_72308_g != null && !grapplingTarget.field_72308_g.func_70089_S())) {
            return null;
        }
        return grapplingTarget;
    }
}

