/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.EntityLevitatingBlock;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class GreaterTelekinesis
extends SpellRay {
    public static final String HOLD_RANGE = "hold_range";
    public static final String THROW_VELOCITY = "throw_velocity";
    private static final float UNDERSHOOT = 0.2f;

    public GreaterTelekinesis() {
        super("greater_telekinesis", SpellActions.POINT, true);
        this.aimAssist(0.4f);
        this.particleSpacing(1.0);
        this.particleJitter(0.05);
        this.particleVelocity(0.3);
        this.addProperties(HOLD_RANGE, THROW_VELOCITY, "damage");
        this.soundValues(0.8f, 1.0f, 0.2f);
    }

    @Override
    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    @Override
    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    @Override
    protected SoundEvent[] createSounds() {
        return this.createContinuousSpellSounds();
    }

    @Override
    protected void playSound(World world, EntityLivingBase entity, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, entity, ticksInUse);
    }

    @Override
    protected void playSound(World world, double x, double y, double z, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster != null && (target instanceof EntityLivingBase || target instanceof EntityLevitatingBlock || target instanceof EntityTNTPrimed)) {
            if (target instanceof EntityPlayer && (caster instanceof EntityPlayer && !Wizardry.settings.playersMoveEachOther || ItemArtefact.isArtefactActive((EntityPlayer)target, WizardryItems.amulet_anchoring))) {
                if (!world.field_72995_K && caster instanceof EntityPlayer) {
                    ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}), true);
                }
                return false;
            }
            if (target instanceof EntityLevitatingBlock) {
                ((EntityLevitatingBlock)target).suspend();
                ((EntityLevitatingBlock)target).setCaster(caster);
            }
            Vec3d targetPos = target.func_174791_d().func_72441_c(0.0, (double)(target.field_70131_O / 2.0f), 0.0);
            if (caster.func_70093_af()) {
                Vec3d look = caster.func_70040_Z().func_186678_a((double)(this.getProperty(THROW_VELOCITY).floatValue() * modifiers.get(WizardryItems.range_upgrade)));
                target.func_70024_g(look.field_72450_a, look.field_72448_b, look.field_72449_c);
                if (caster instanceof EntityPlayer) {
                    caster.func_184609_a(caster.func_184600_cs() == null ? EnumHand.MAIN_HAND : caster.func_184600_cs());
                }
            } else {
                EntityUtils.undoGravity(target);
                Vec3d vec = origin.func_178787_e(caster.func_70040_Z().func_186678_a((double)this.getProperty(HOLD_RANGE).floatValue()));
                Vec3d velocity = vec.func_178788_d(targetPos).func_178786_a(target.field_70159_w, target.field_70181_x, target.field_70179_y).func_186678_a((double)0.8f);
                target.func_70024_g(velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
            }
            if (target instanceof EntityPlayerMP) {
                ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(target));
            }
            if (world.field_72995_K) {
                ParticleBuilder.create(ParticleBuilder.Type.BEAM).entity((Entity)caster).clr(0.2f, 0.6f + 0.3f * world.field_73012_v.nextFloat(), 1.0f).pos(origin.func_178788_d(caster.func_174791_d())).target(target).time(0).scale(MathHelper.func_76126_a((float)((float)ticksInUse * 0.3f)) * 0.1f + 0.9f).spawn(world);
                if (ticksInUse % 18 == 1) {
                    ParticleBuilder.create(ParticleBuilder.Type.FLASH).entity(target).pos(0.0, target.field_70131_O / 2.0f, 0.0).scale(2.5f).time(30).clr(0.2f, 0.8f, 1.0f).fade(1.0f, 1.0f, 1.0f).spawn(world);
                }
                ParticleBuilder.create(ParticleBuilder.Type.SPARKLE, target).vel(0.0, 0.05, 0.0).time(15).scale(0.6f).clr(0.2f, 0.6f, 1.0f).fade(1.0f, 1.0f, 1.0f).spawn(world);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (EntityUtils.canDamageBlocks((Entity)caster, world) && !BlockUtils.isBlockUnbreakable(world, pos) && world.func_180495_p(pos).func_185904_a().func_76220_a() && (world.func_175625_s(pos) == null || !world.func_175625_s(pos).getTileData().func_186855_b("arcaneLockOwner"))) {
            if (!world.field_72995_K) {
                EntityLevitatingBlock block = new EntityLevitatingBlock(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, world.func_180495_p(pos));
                block.field_145812_b = 1;
                block.damageMultiplier = modifiers.get("potency");
                block.setCaster(caster);
                world.func_72838_d((Entity)block);
                world.func_175698_g(pos);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }
}

