/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class GuardianBeam
extends SpellRay {
    public static final String AIR_DEPLETION = "air_depletion";

    public GuardianBeam() {
        super("guardian_beam", SpellActions.POINT, true);
        this.addProperties("damage", AIR_DEPLETION);
    }

    @Override
    protected void playSound(World world, double x, double y, double z, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        if (ticksInUse % 50 == 1) {
            super.playSound(world, x, y, z, ticksInUse, duration, modifiers, sounds);
        }
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (EntityUtils.isLiving(target)) {
            if (ticksInUse % 50 == 1) {
                EntityUtils.attackEntityWithoutKnockback(target, MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.MAGIC), this.getProperty("damage").floatValue() * modifiers.get("potency"));
                if (!((EntityLivingBase)target).func_70648_aU() && !((EntityLivingBase)target).func_70644_a(MobEffects.field_76427_o)) {
                    target.func_70050_g(Math.max(-20, target.func_70086_ai() - this.getProperty(AIR_DEPLETION).intValue()));
                }
            }
            if (world.field_72995_K) {
                float t = (float)(ticksInUse % 50) / 50.0f;
                float yellowness = t * t;
                int r = 64 + (int)(yellowness * 191.0f);
                int g = 32 + (int)(yellowness * 191.0f);
                int b = 128 - (int)(yellowness * 64.0f);
                if (ticksInUse % 3 == 0) {
                    ParticleBuilder.create(ParticleBuilder.Type.GUARDIAN_BEAM).entity((Entity)caster).pos(caster != null ? origin.func_178788_d(caster.func_174791_d()) : origin).target(target).clr(r, g, b).spawn(world);
                }
                Vec3d direction = GeometryUtils.getCentre(target).func_178788_d(origin);
                Vec3d pos = origin.func_178787_e(direction.func_186678_a((double)world.field_73012_v.nextFloat()));
                ParticleBuilder.create(ParticleBuilder.Type.MAGIC_BUBBLE, world.field_73012_v, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.15, false).spawn(world);
            }
        }
        return true;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
    }
}

