/*
 * Decompiled with CFR 0.152.
 */
package com.mmyzd.llor;

import com.mmyzd.llor.LightLevelOverlayReloaded;
import com.mmyzd.llor.Overlay;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.Chunk;

public class OverlayPoller
extends Thread {
    public volatile ArrayList<Overlay>[][] overlays;

    @Override
    public void run() {
        int radius = 0;
        while (true) {
            int chunkRadius = this.updateChunkRadius();
            radius = radius % chunkRadius + 1;
            if (LightLevelOverlayReloaded.instance.active) {
                this.updateLightLevel(radius, chunkRadius);
            }
            try {
                OverlayPoller.sleep(LightLevelOverlayReloaded.instance.config.pollingInterval.getInt());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private int updateChunkRadius() {
        int size = LightLevelOverlayReloaded.instance.config.chunkRadius.getInt();
        if (this.overlays == null || this.overlays.length != size * 2 + 1) {
            this.overlays = new ArrayList[size * 2 + 1][size * 2 + 1];
            for (int i = 0; i < this.overlays.length; ++i) {
                for (int j = 0; j < this.overlays[i].length; ++j) {
                    this.overlays[i][j] = new ArrayList();
                }
            }
        }
        return size;
    }

    private void updateLightLevel(int radius, int chunkRadius) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        WorldClient world = mc.field_71441_e;
        int playerPosY = (int)Math.floor(mc.field_71439_g.field_70163_u);
        int playerChunkX = mc.field_71439_g.field_70176_ah;
        int playerChunkZ = mc.field_71439_g.field_70164_aj;
        int skyLightSub = world.func_72967_a(1.0f);
        int displayMode = LightLevelOverlayReloaded.instance.config.displayMode.getInt();
        boolean useSkyLight = LightLevelOverlayReloaded.instance.config.useSkyLight.getBoolean();
        for (int chunkX = playerChunkX - radius; chunkX <= playerChunkX + radius; ++chunkX) {
            for (int chunkZ = playerChunkZ - radius; chunkZ <= playerChunkZ + radius; ++chunkZ) {
                Chunk chunk = mc.field_71441_e.func_72964_e(chunkX, chunkZ);
                if (!chunk.func_177410_o()) continue;
                ArrayList<Overlay> buffer = new ArrayList<Overlay>();
                for (int offsetX = 0; offsetX < 16; ++offsetX) {
                    for (int offsetZ = 0; offsetZ < 16; ++offsetZ) {
                        int posX = (chunkX << 4) + offsetX;
                        int posZ = (chunkZ << 4) + offsetZ;
                        int maxY = playerPosY + 4;
                        int minY = Math.max(playerPosY - 40, 0);
                        IBlockState preBlockState = null;
                        IBlockState curBlockState = chunk.func_186032_a(offsetX, maxY, offsetZ);
                        Block preBlock = null;
                        Block curBlock = curBlockState.func_177230_c();
                        BlockPos prePos = null;
                        BlockPos curPos = new BlockPos(posX, maxY, posZ);
                        for (int posY = maxY - 1; posY >= minY; --posY) {
                            int lightIndex;
                            preBlockState = curBlockState;
                            curBlockState = chunk.func_186032_a(offsetX, posY, offsetZ);
                            preBlock = curBlock;
                            curBlock = curBlockState.func_177230_c();
                            prePos = curPos;
                            curPos = new BlockPos(posX, posY, posZ);
                            if (curBlock == Blocks.field_150350_a || curBlock == Blocks.field_150357_h || curBlock == Blocks.field_180401_cv || preBlockState.func_185898_k() || preBlockState.func_185904_a().func_76224_d() || preBlockState.func_185897_m() || !curBlockState.isSideSolid((IBlockAccess)world, curPos, EnumFacing.UP) || BlockRailBase.func_176563_d((IBlockState)preBlockState)) continue;
                            double offsetY = 0.0;
                            if ((preBlock == Blocks.field_150431_aC || preBlock == Blocks.field_150404_cg) && (offsetY = preBlockState.func_185900_c((IBlockAccess)world, (BlockPos)prePos).field_72337_e) >= 0.15) continue;
                            int blockLight = chunk.func_177413_a(EnumSkyBlock.BLOCK, prePos);
                            int skyLight = chunk.func_177413_a(EnumSkyBlock.SKY, prePos) - skyLightSub;
                            int mixedLight = Math.max(blockLight, skyLight);
                            int n = lightIndex = useSkyLight ? mixedLight : blockLight;
                            if (displayMode == 1) {
                                if (mixedLight >= 8 && blockLight < 8) {
                                    lightIndex += 32;
                                }
                            } else if (displayMode == 2) {
                                if (blockLight >= 8) continue;
                                if (lightIndex >= 8) {
                                    lightIndex += 32;
                                }
                            }
                            if (lightIndex >= 8 && lightIndex < 24) {
                                lightIndex ^= 0x10;
                            }
                            buffer.add(new Overlay(posX, (double)posY + offsetY + 1.0, posZ, lightIndex));
                        }
                    }
                }
                int len = chunkRadius * 2 + 1;
                int arrayX = (chunkX % len + len) % len;
                int arrayZ = (chunkZ % len + len) % len;
                this.overlays[arrayX][arrayZ] = buffer;
            }
        }
    }
}

