/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.requirement;

import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentOutputRestrictor;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.ProcessingComponent;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.crafting.requirement.jei.JEIComponentEnergy;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementTypeEnergy;
import hellfirepvp.modularmachinery.common.lib.ComponentTypesMM;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.IEnergyHandler;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;

public class RequirementEnergy
extends ComponentRequirement.PerTick<Long, RequirementTypeEnergy> {
    public final long requirementPerTick;
    private long activeIO;

    public RequirementEnergy(IOType ioType, long requirementPerTick) {
        super(RequirementTypesMM.REQUIREMENT_ENERGY, ioType);
        this.activeIO = this.requirementPerTick = requirementPerTick;
    }

    @Override
    public int getSortingWeight() {
        return 50000000;
    }

    @Override
    public ComponentRequirement<Long, RequirementTypeEnergy> deepCopy() {
        RequirementEnergy energy = new RequirementEnergy(this.getActionType(), this.requirementPerTick);
        energy.activeIO = this.activeIO;
        return energy;
    }

    @Override
    public ComponentRequirement<Long, RequirementTypeEnergy> deepCopyModified(List<RecipeModifier> modifiers) {
        int requirement = Math.round(RecipeModifier.applyModifiers(modifiers, this, (float)this.requirementPerTick, false));
        RequirementEnergy energy = new RequirementEnergy(this.getActionType(), requirement);
        energy.activeIO = this.activeIO;
        return energy;
    }

    @Override
    public void startRequirementCheck(ResultChance contextChance, RecipeCraftingContext context) {
    }

    @Override
    public void endRequirementCheck() {
    }

    @Override
    @Nonnull
    public String getMissingComponentErrorMessage(IOType ioType) {
        ResourceLocation compKey = ((RequirementTypeEnergy)((Object)this.getRequirementType())).getRegistryName();
        return String.format("component.missing.%s.%s.%s", compKey.func_110624_b(), compKey.func_110623_a(), ioType.name().toLowerCase());
    }

    public long getRequiredEnergyPerTick() {
        return this.requirementPerTick;
    }

    @Override
    public ComponentRequirement.JEIComponent<Long> provideJEIComponent() {
        return new JEIComponentEnergy(this);
    }

    @Override
    public boolean isValidComponent(ProcessingComponent<?> component, RecipeCraftingContext ctx) {
        MachineComponent<?> cmp = component.getComponent();
        return cmp.getComponentType().equals((Object)ComponentTypesMM.COMPONENT_ENERGY) && cmp instanceof MachineComponent.EnergyHatch && cmp.getIOType() == this.getActionType();
    }

    @Override
    @Nonnull
    public CraftCheck canStartCrafting(ProcessingComponent<?> component, RecipeCraftingContext context, List<ComponentOutputRestrictor> restrictions) {
        IEnergyHandler handler = (IEnergyHandler)component.getProvidedComponent();
        switch (this.getActionType()) {
            case INPUT: {
                if (!((float)handler.getCurrentEnergy() >= RecipeModifier.applyModifiers(context, this, (float)this.requirementPerTick, false))) break;
                return CraftCheck.success();
            }
            case OUTPUT: {
                return CraftCheck.success();
            }
        }
        return CraftCheck.failure("craftcheck.failure.energy.input");
    }

    @Override
    public boolean startCrafting(ProcessingComponent<?> component, RecipeCraftingContext context, ResultChance chance) {
        return this.canStartCrafting(component, context, Lists.newArrayList()).isSuccess();
    }

    @Override
    @Nonnull
    public CraftCheck finishCrafting(ProcessingComponent<?> component, RecipeCraftingContext context, ResultChance chance) {
        return CraftCheck.success();
    }

    @Override
    public void startIOTick(RecipeCraftingContext context, float durationMultiplier) {
        this.activeIO = Math.round((double)RecipeModifier.applyModifiers(context, this, (float)this.activeIO, false) * (double)durationMultiplier);
    }

    @Override
    @Nonnull
    public CraftCheck resetIOTick(RecipeCraftingContext context) {
        boolean enough = this.activeIO <= 0L;
        this.activeIO = this.requirementPerTick;
        return enough ? CraftCheck.success() : CraftCheck.failure("craftcheck.failure.energy.input");
    }

    @Override
    @Nonnull
    public CraftCheck doIOTick(ProcessingComponent<?> component, RecipeCraftingContext context) {
        IEnergyHandler handler = (IEnergyHandler)component.getProvidedComponent();
        switch (this.getActionType()) {
            case INPUT: {
                if (handler.getCurrentEnergy() >= this.activeIO) {
                    handler.setCurrentEnergy(handler.getCurrentEnergy() - this.activeIO);
                    this.activeIO = 0L;
                    return CraftCheck.success();
                }
                this.activeIO -= handler.getCurrentEnergy();
                handler.setCurrentEnergy(0L);
                return CraftCheck.partialSuccess();
            }
            case OUTPUT: {
                long remaining = handler.getRemainingCapacity();
                if (remaining - this.activeIO < 0L) {
                    handler.setCurrentEnergy(handler.getMaxEnergy());
                    this.activeIO -= remaining;
                    return CraftCheck.partialSuccess();
                }
                handler.setCurrentEnergy(Math.min(handler.getCurrentEnergy() + this.activeIO, handler.getMaxEnergy()));
                this.activeIO = 0L;
                return CraftCheck.success();
            }
        }
        return CraftCheck.skipComponent();
    }
}

