/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.alchemy.block;

import com.bartz24.skyresources.RandomHelper;
import com.bartz24.skyresources.alchemy.tile.CrucibleTile;
import com.bartz24.skyresources.base.block.BlockMachine;
import com.bartz24.skyresources.config.ConfigOptions;
import com.bartz24.skyresources.registry.ModCreativeTabs;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class CrucibleBlock
extends BlockMachine {
    protected static final AxisAlignedBB AABB_LEGS = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0);
    protected static final AxisAlignedBB AABB_WALL_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    protected static final AxisAlignedBB AABB_WALL_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_WALL_EAST = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_WALL_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);

    public CrucibleBlock(String unlocalizedName, String registryName, float hardness, float resistance) {
        super(Material.field_151576_e);
        this.func_149663_c("skyresources." + unlocalizedName);
        this.func_149647_a(ModCreativeTabs.tabAlchemy);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.setRegistryName(registryName);
        this.field_149758_A = true;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        CrucibleBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_LEGS);
        CrucibleBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_WEST);
        CrucibleBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_NORTH);
        CrucibleBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_EAST);
        CrucibleBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_SOUTH);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new CrucibleTile();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && !player.func_184586_b(hand).func_190926_b()) {
            CrucibleTile tile = (CrucibleTile)world.func_175625_s(pos);
            FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)player.func_184586_b(hand), (IFluidHandler)tile.getTank(), (int)tile.getTank().getFluidAmount(), (EntityPlayer)player, (boolean)true);
            if (result.success) {
                if (player.func_184586_b(hand).func_190916_E() > 1) {
                    player.func_184586_b(hand).func_190918_g(1);
                    RandomHelper.spawnItemInWorld(world, result.getResult(), player.func_180425_c());
                } else {
                    player.func_184611_a(hand, result.getResult());
                }
                return true;
            }
            ItemStack contents = player.func_184586_b(hand).func_77946_l();
            contents.func_190920_e(1);
            return true;
        }
        return true;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        CrucibleTile tile = (CrucibleTile)world.func_175625_s(pos);
        int val = (int)((float)tile.getItemAmount() * 15.0f / (float)ConfigOptions.machineSettings.crucibleCapacity);
        if (tile.getItemAmount() > 0) {
            val = Math.max(val, 1);
        }
        return val;
    }
}

