/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.alchemy.tile;

import com.bartz24.skyresources.base.HeatSources;
import com.bartz24.skyresources.config.ConfigOptions;
import com.bartz24.skyresources.recipe.ProcessRecipe;
import com.bartz24.skyresources.recipe.ProcessRecipeManager;
import com.bartz24.skyresources.technology.tile.TileCrucibleInserter;
import java.util.List;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class CrucibleTile
extends TileEntity
implements ITickable,
IFluidHandler {
    FluidTank tank;
    public static int tankCapacity = ConfigOptions.machineSettings.crucibleCapacity;
    public ItemStack itemIn = ItemStack.field_190927_a;
    public int itemAmount;
    int maxItemAmount;

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null) {
            int filled = this.tank.fill(resource, doFill);
            this.func_70296_d();
            return filled;
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource != null) {
            this.func_70296_d();
            return this.tank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public CrucibleTile() {
        this.maxItemAmount = ConfigOptions.machineSettings.crucibleCapacity;
        this.tank = new FluidTank(tankCapacity);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_189515_b(nbtTag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            List list = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o() + 0.2, (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)));
            for (EntityItem entity : list) {
                this.insertStack(entity.func_92059_d());
            }
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
            if (tile != null && tile instanceof TileCrucibleInserter && !((TileCrucibleInserter)tile).getInventory().getStackInSlot(0).func_190926_b()) {
                this.insertStack(((TileCrucibleInserter)tile).getInventory().getStackInSlot(0));
            }
            if (this.itemAmount > 0) {
                int val = Math.min(this.getHeatSourceVal(), this.itemAmount);
                if (this.itemIn != ItemStack.field_190927_a && val > 0 && this.tank.getFluidAmount() + val <= this.tank.getCapacity()) {
                    ProcessRecipe recipe = ProcessRecipeManager.crucibleRecipes.getRecipe(this.itemIn, 0.0f, false, false);
                    this.tank.fill(new FluidStack(recipe.getFluidOutputs().get(0), val), true);
                    this.itemAmount -= val;
                }
                if (this.tank.getFluidAmount() == 0 && this.itemAmount == 0) {
                    this.itemIn = ItemStack.field_190927_a;
                }
                this.func_70296_d();
            }
        }
    }

    private void insertStack(ItemStack stack) {
        int amount;
        ProcessRecipe recipe = ProcessRecipeManager.crucibleRecipes.getRecipe(stack, 0.0f, false, false);
        int n = amount = recipe == null ? 0 : recipe.getFluidOutputs().get((int)0).amount;
        if (this.itemAmount + amount <= this.maxItemAmount && recipe != null) {
            ItemStack input = (ItemStack)recipe.getInputs().get(0);
            if (this.tank.getFluid() == null || this.tank.getFluid().getFluid() == null) {
                this.itemIn = input;
            }
            if (this.itemIn == input) {
                this.itemAmount += amount;
                stack.func_190918_g(1);
            }
            this.func_70296_d();
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), this.field_145850_b.func_180495_p(this.func_174877_v()), 0);
        }
    }

    public void markDirtyBlockUpdate() {
        super.func_70296_d();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), this.field_145850_b.func_180495_p(this.func_174877_v()), 0);
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), this.field_145850_b.func_180495_p(this.func_174877_v()), 3);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145854_h, true);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.tank.writeToNBT(compound);
        compound.func_74768_a("amount", this.itemAmount);
        NBTTagCompound stackTag = new NBTTagCompound();
        if (this.itemIn != ItemStack.field_190927_a) {
            this.itemIn.func_77955_b(stackTag);
        }
        compound.func_74782_a("Item", (NBTBase)stackTag);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tank.readFromNBT(compound);
        this.itemAmount = compound.func_74762_e("amount");
        NBTTagCompound stackTag = compound.func_74775_l("Item");
        if (stackTag != null) {
            this.itemIn = new ItemStack(stackTag);
        }
    }

    int getHeatSourceVal() {
        if (HeatSources.isValidHeatSource(this.field_174879_c.func_177977_b(), this.field_145850_b) && HeatSources.getHeatSourceValue(this.field_174879_c.func_177977_b(), this.field_145850_b) > 0) {
            return (int)Math.max((float)HeatSources.getHeatSourceValue(this.field_174879_c.func_177977_b(), this.field_145850_b) * (float)ConfigOptions.machineSettings.crucibleSpeed / 8.0f, 1.0f);
        }
        return 0;
    }

    public int getItemAmount() {
        return this.itemAmount;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }
}

