/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.technology.tile;

import com.bartz24.skyresources.base.tile.TileBase;
import com.bartz24.skyresources.config.ConfigOptions;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidDropperTile
extends TileBase
implements ITickable,
IFluidHandler {
    FluidTank tank;

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null) {
            int filled = this.tank.fill(resource, doFill);
            return filled;
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource != null) {
            return this.tank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public FluidDropperTile() {
        super("fluidDropper");
        this.tank = new FluidTank(ConfigOptions.machineSettings.fluidDropperCapacity);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.tank.writeToNBT(compound);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tank.readFromNBT(compound);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.pullFromAround();
            if (this.tank.getFluidAmount() >= 1000 && this.field_145850_b.func_175623_d(this.field_174879_c.func_177977_b())) {
                this.field_145850_b.func_175656_a(this.field_174879_c.func_177977_b(), this.tank.getFluid().getFluid().getBlock().func_176223_P());
                this.tank.setFluid(null);
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187624_K, SoundCategory.BLOCKS, 0.5f, 1.0f, true);
            }
        }
    }

    void pullFromAround() {
        EnumFacing[] enumFacingArray = new EnumFacing[5];
        enumFacingArray[0] = EnumFacing.UP;
        enumFacingArray[1] = EnumFacing.NORTH;
        enumFacingArray[2] = EnumFacing.SOUTH;
        enumFacingArray[3] = EnumFacing.WEST;
        enumFacingArray[4] = EnumFacing.EAST;
        EnumFacing[] checkPoses = enumFacingArray;
        if (this.getRedstoneSignal() == 0) {
            for (EnumFacing dir : checkPoses) {
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177971_a(dir.func_176730_m()));
                if (tile == null || !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir)) continue;
                IFluidHandler fluidHand = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir);
                for (IFluidTankProperties inputTank : fluidHand.getTankProperties()) {
                    FluidStack inputFluid = inputTank.getContents();
                    if (this.tank.getFluid() != null && (inputFluid == null || !inputFluid.isFluidEqual(this.tank.getFluid()))) continue;
                    this.fill(fluidHand.drain(ConfigOptions.machineSettings.fluidDropperCapacity - this.tank.getFluidAmount(), true), true);
                    if (ConfigOptions.machineSettings.fluidDropperCapacity > this.tank.getFluidAmount()) continue;
                    return;
                }
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }
}

