/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.railcraft;

import mods.railcraft.common.fluids.RailcraftFluids;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import techreborn.api.RollingMachineRecipe;
import techreborn.api.generator.EFluidGenerator;
import techreborn.api.generator.GeneratorRecipeHelper;
import techreborn.compat.ICompatModule;

@RebornRegistry(modOnly="railcraft", modID="techreborn")
public class RailcraftCompat
implements ICompatModule {
    @ConfigRegistry(config="compat", category="railcraft", key="DisableRailRelatedRollingMachinesRecipes", comment="Disable rolling machine rail related recipes when Railcraft is installed")
    public static boolean disableRailRelatedRollingMachinesRecipes = true;
    @ConfigRegistry(config="compat", category="railcraft", key="EnableRailcraftFuels", comment="Allow Railcraft fuels to be used in the fuel generators (i.e. Creosote)")
    public static boolean allowRailcraftFuels = true;

    public void init(FMLInitializationEvent event) {
        if (disableRailRelatedRollingMachinesRecipes) {
            RollingMachineRecipe.instance.getRecipeList().remove(new ResourceLocation("techreborn", "rail"));
            RollingMachineRecipe.instance.getRecipeList().remove(new ResourceLocation("techreborn", "gold_rail"));
            RollingMachineRecipe.instance.getRecipeList().remove(new ResourceLocation("techreborn", "detector_rail"));
            RollingMachineRecipe.instance.getRecipeList().remove(new ResourceLocation("techreborn", "activator_rail"));
            RollingMachineRecipe.instance.getRecipeList().remove(new ResourceLocation("techreborn", "minecart"));
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        if (allowRailcraftFuels) {
            GeneratorRecipeHelper.registerFluidRecipe((EFluidGenerator)EFluidGenerator.SEMIFLUID, (Fluid)RailcraftFluids.CREOSOTE.getBlock().getFluid(), (int)3);
        }
    }
}

