/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.client.gui;

import com.blakebr0.cucumber.helper.ResourceHelper;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.extendedcrafting.client.container.ContainerCraftingCore;
import com.blakebr0.extendedcrafting.crafting.CombinationRecipe;
import com.blakebr0.extendedcrafting.tile.TileCraftingCore;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiCraftingCore
extends GuiContainer {
    private static final ResourceLocation GUI = ResourceHelper.getResource((String)"extendedcrafting", (String)"textures/gui/crafting_core.png");
    private TileCraftingCore tile;

    public GuiCraftingCore(TileCraftingCore tile, ContainerCraftingCore container) {
        super((Container)container);
        this.tile = tile;
        this.field_146999_f = 176;
        this.field_147000_g = 194;
    }

    private int getEnergyBarScaled(int pixels) {
        int i = this.tile.getEnergy().getEnergyStored();
        int j = this.tile.getEnergy().getMaxEnergyStored();
        return (int)(j != 0 && i != 0 ? (long)i * (long)pixels / (long)j : 0L);
    }

    private int getProgressBarScaled(int pixels) {
        int i = this.tile.getProgress();
        int j = this.tile.getRecipe().getCost();
        return (int)(j != 0 && i != 0 ? (long)i * (long)pixels / (long)j : 0L);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = Utils.localize((String)"container.ec.crafting_core");
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(Utils.localize((String)"container.inventory"), 8, this.field_147000_g - 94, 0x404040);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
        this.field_146289_q.func_78276_b(Utils.localize((String)"ec.ccore.pedestals", (Object[])new Object[]{this.tile.getPedestalCount()}), 36, 36, -1);
        CombinationRecipe recipe = this.tile.getRecipe();
        if (recipe == null) {
            this.field_146289_q.func_78276_b(Utils.localize((String)"ec.ccore.no_recipe"), 36, 56, -1);
        } else {
            this.field_146289_q.func_78276_b(Utils.localize((String)"ec.ccore.rf_cost", (Object[])new Object[]{Utils.format((Object)recipe.getCost())}) + " FE", 36, 56, -1);
            this.field_146289_q.func_78276_b(Utils.localize((String)"ec.ccore.rf_rate", (Object[])new Object[]{Utils.format((Object)recipe.getPerTick())}) + " FE/t", 36, 66, -1);
            if (this.tile.getEnergy().getEnergyStored() < recipe.getPerTick()) {
                this.field_146289_q.func_78276_b(Utils.localize((String)"ec.ccore.no_power"), 36, 86, -1);
            }
        }
        GlStateManager.func_179121_F();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int left = this.field_147003_i;
        int top = this.field_147009_r;
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        if (this.tile.getRecipe() != null) {
            ItemStack output = this.tile.getRecipe().getOutput();
            this.drawFakeItemStack(output, 148, 47, mouseX, mouseY);
            this.drawFakeItemStackTooltip(output, 148, 47, mouseX, mouseY);
        }
        if (mouseX > left + 7 && mouseX < this.field_147003_i + 20 && mouseY > this.field_147009_r + 17 && mouseY < this.field_147009_r + 94) {
            this.func_146279_a(Utils.format((Object)this.tile.getEnergy().getEnergyStored()) + " FE", mouseX, mouseY);
        }
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(GUI);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        int i1 = this.getEnergyBarScaled(78);
        this.func_73729_b(x + 7, y + 95 - i1, 178, 78 - i1, 15, i1 + 1);
        CombinationRecipe recipe = this.tile.getRecipe();
        if (this.tile != null && recipe != null && this.tile.getProgress() > 0 && recipe.getCost() > 0) {
            int i2 = this.getProgressBarScaled(24);
            this.func_73729_b(x + 116, y + 47, 194, 0, i2 + 1, 16);
        }
    }

    private void drawItemStack(ItemStack stack, int x, int y, String altText) {
        GlStateManager.func_179094_E();
        RenderHelper.func_74520_c();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-32.0f);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.field_146289_q;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(font, stack, x, y, altText);
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
    }

    private void drawFakeItemStack(ItemStack stack, int xOffset, int yOffset, int mouseX, int mouseY) {
        this.drawItemStack(stack, this.field_147003_i + xOffset, this.field_147009_r + yOffset, null);
    }

    private void drawFakeItemStackTooltip(ItemStack stack, int xOffset, int yOffset, int mouseX, int mouseY) {
        if (mouseX > this.field_147003_i + xOffset - 1 && mouseX < this.field_147003_i + xOffset + 16 && mouseY > this.field_147009_r + yOffset - 1 && mouseY < this.field_147009_r + yOffset + 16 && !stack.func_190926_b()) {
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.func_73733_a(this.field_147003_i + xOffset, this.field_147009_r + yOffset, this.field_147003_i + xOffset + 16, this.field_147009_r + yOffset + 16, -2130706433, -2130706433);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            this.func_146285_a(stack, mouseX, mouseY);
        }
    }
}

