/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab;

import mekanism.api.transmitters.TransmissionType;
import mekanism.client.gui.GuiSideConfiguration;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.sound.SoundHandler;
import mekanism.common.util.MekanismUtils;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiConfigTypeTab
extends GuiElement {
    private final TransmissionType transmission;
    private boolean visible;
    private boolean left;
    private int yPos;

    public GuiConfigTypeTab(IGuiWrapper gui, TransmissionType type, ResourceLocation def) {
        super(GuiConfigTypeTab.getResource(type), gui, def);
        this.transmission = type;
    }

    private static ResourceLocation getResource(TransmissionType t) {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, "Gui" + t.getTransmission() + "Tab.png");
    }

    public void setY(int y) {
        this.yPos = y;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setLeft(boolean left) {
        this.left = left;
    }

    public TransmissionType getTransmissionType() {
        return this.transmission;
    }

    @Override
    public GuiElement.Rectangle4i getBounds(int guiWidth, int guiHeight) {
        return new GuiElement.Rectangle4i(guiWidth + this.getLeftBound(false) - 4, guiHeight + this.yPos, 26, 26);
    }

    @Override
    protected boolean inBounds(int xAxis, int yAxis) {
        return xAxis >= this.getLeftBound(true) && xAxis <= this.getRightBound(true) && yAxis >= this.yPos + 4 && yAxis <= this.yPos + 22;
    }

    @Override
    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        if (this.visible) {
            GuiConfigTypeTab.mc.field_71446_o.func_110577_a(this.RESOURCE);
            this.guiObj.drawTexturedRect(guiWidth + this.getLeftBound(false) - 4, guiHeight + this.yPos, 0, this.left ? 0 : 26, 26, 26);
            this.guiObj.drawTexturedRect(guiWidth + this.getLeftBound(true), guiHeight + this.yPos + 4, 26, this.inBounds(xAxis, yAxis) ? 0 : 18, 18, 18);
            GuiConfigTypeTab.mc.field_71446_o.func_110577_a(this.defaultLocation);
        }
    }

    @Override
    public void renderForeground(int xAxis, int yAxis) {
        if (this.visible) {
            GuiConfigTypeTab.mc.field_71446_o.func_110577_a(this.RESOURCE);
            if (this.inBounds(xAxis, yAxis)) {
                this.displayTooltip(this.transmission.localize(), xAxis, yAxis);
            }
            GuiConfigTypeTab.mc.field_71446_o.func_110577_a(this.defaultLocation);
        }
    }

    public int getLeftBound(boolean adjust) {
        return this.left ? -21 + (adjust ? 1 : 0) : 179 - (adjust ? 1 : 0);
    }

    public int getRightBound(boolean adjust) {
        return this.left ? -3 + (adjust ? 1 : 0) : 197 - (adjust ? 1 : 0);
    }

    @Override
    public void preMouseClicked(int xAxis, int yAxis, int button) {
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
        if (this.visible && button == 0 && this.inBounds(xAxis, yAxis)) {
            ((GuiSideConfiguration)this.guiObj).setCurrentType(this.transmission);
            ((GuiSideConfiguration)this.guiObj).updateTabs();
            SoundHandler.playSound(SoundEvents.field_187909_gi);
        }
    }
}

