/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import mekanism.common.PacketHandler;
import mekanism.common.entity.EntityRobit;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketRobit
implements IMessageHandler<RobitMessage, IMessage> {
    public IMessage onMessage(RobitMessage message, MessageContext context) {
        EntityPlayer player = PacketHandler.getPlayer(context);
        PacketHandler.handlePacket(() -> {
            EntityRobit robit = (EntityRobit)player.field_70170_p.func_73045_a(message.entityId);
            if (robit != null) {
                switch (message.activeType) {
                    case FOLLOW: {
                        robit.setFollowing(!robit.getFollowing());
                        break;
                    }
                    case NAME: {
                        robit.func_96094_a(message.name);
                        break;
                    }
                    case GO_HOME: {
                        robit.goHome();
                        break;
                    }
                    case DROP_PICKUP: {
                        robit.setDropPickup(!robit.getDropPickup());
                    }
                }
            }
        }, player);
        return null;
    }

    public static class RobitMessage
    implements IMessage {
        public RobitPacketType activeType;
        public int entityId;
        public String name;

        public RobitMessage() {
        }

        public RobitMessage(RobitPacketType type, int entityId, @Nullable String name) {
            this.activeType = type;
            this.entityId = entityId;
            if (this.activeType == RobitPacketType.NAME) {
                this.name = name;
            }
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.activeType.ordinal());
            dataStream.writeInt(this.entityId);
            if (this.activeType == RobitPacketType.NAME) {
                PacketHandler.writeString(dataStream, this.name);
            }
        }

        public void fromBytes(ByteBuf dataStream) {
            this.activeType = RobitPacketType.values()[dataStream.readInt()];
            this.entityId = dataStream.readInt();
            if (this.activeType == RobitPacketType.NAME) {
                this.name = PacketHandler.readString(dataStream);
            }
        }
    }

    public static enum RobitPacketType {
        FOLLOW,
        NAME,
        GO_HOME,
        DROP_PICKUP;

    }
}

