/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.skygrid.core;

import funwayguy.skygrid.config.GridRegistry;
import funwayguy.skygrid.core.proxies.CommonProxy;
import funwayguy.skygrid.handlers.ConfigHandler;
import funwayguy.skygrid.world.PostGenerator;
import funwayguy.skygrid.world.WorldProviderEndGrid;
import funwayguy.skygrid.world.WorldProviderNetherGrid;
import funwayguy.skygrid.world.WorldProviderOverworldGrid;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.Logger;

@Mod(modid="skygrid", version="1.1.7", name="Sky Grid", guiFactory="funwayguy.skygrid.handlers.ConfigGuiFactory", acceptedMinecraftVersions="[1.12.2]")
public class SkyGrid {
    public static final String MODID = "skygrid";
    public static final String NAME = "Sky Grid";
    public static final String PROXY = "funwayguy.skygrid.core.proxies";
    public static final String CHANNEL = "SKY_CHAN";
    public static WorldType gridWorld;
    @Mod.Instance(value="skygrid")
    public static SkyGrid instance;
    @SidedProxy(clientSide="funwayguy.skygrid.core.proxies.ClientProxy", serverSide="funwayguy.skygrid.core.proxies.CommonProxy")
    public static CommonProxy proxy;
    public SimpleNetworkWrapper network;
    public static Logger logger;
    private static boolean inUse;
    private static DimensionType[] origCache;
    private static DimensionType[] gridCache;
    public static DimensionType[] abyssGrids;
    public static DimensionType[] abyssNorm;
    public static int[] abyssDimIDs;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        this.network = NetworkRegistry.INSTANCE.newSimpleChannel(CHANNEL);
        ConfigHandler.config = new Configuration(event.getSuggestedConfigurationFile(), true);
        ConfigHandler.initConfigs();
        proxy.registerHandlers();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerRenderers();
        gridWorld = new WorldType(MODID);
        SkyGrid.gridCache[0] = DimensionType.register((String)"NetherGrid", (String)"_nethergrid", (int)-1, WorldProviderNetherGrid.class, (boolean)true);
        SkyGrid.gridCache[1] = DimensionType.register((String)"SkyGrid", (String)"_skygrid", (int)0, WorldProviderOverworldGrid.class, (boolean)true);
        SkyGrid.gridCache[2] = DimensionType.register((String)"EndGrid", (String)"_endgrid", (int)1, WorldProviderEndGrid.class, (boolean)true);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new PostGenerator(), (int)0);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        GridRegistry.loadBlocks();
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerAboutToStartEvent event) {
        if (!inUse) {
            boolean enable = false;
            if (!proxy.isClient() && event.getServer() instanceof DedicatedServer) {
                enable = WorldType.func_77130_a((String)((DedicatedServer)event.getServer()).func_71330_a("level-type", "DEFAULT")) == gridWorld;
            } else if (event.getServer() instanceof IntegratedServer) {
                try {
                    WorldSettings set = (WorldSettings)ReflectionHelper.getPrivateValue(IntegratedServer.class, (Object)((IntegratedServer)event.getServer()), (String[])new String[]{"field_71350_m", "worldSettings"});
                    enable = set.func_77165_h() == gridWorld;
                }
                catch (Exception e) {
                    logger.error("Unable to force read server settings", (Throwable)e);
                    enable = false;
                }
            }
            if (enable) {
                int i;
                logger.info("Overriding dimension providers with skygrids...");
                for (i = 0; i < 3; ++i) {
                    SkyGrid.origCache[i] = DimensionManager.getProviderType((int)(i - 1));
                    DimensionManager.unregisterDimension((int)(i - 1));
                    DimensionManager.registerDimension((int)(i - 1), (DimensionType)gridCache[i]);
                }
                if (abyssGrids != null) {
                    for (i = 0; i < abyssDimIDs.length; ++i) {
                        SkyGrid.abyssNorm[i] = DimensionManager.getProviderType((int)abyssDimIDs[i]);
                        DimensionManager.unregisterDimension((int)abyssDimIDs[i]);
                        DimensionManager.registerDimension((int)abyssDimIDs[i], (DimensionType)abyssGrids[i]);
                    }
                }
                inUse = true;
            }
        }
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        if (inUse) {
            int i;
            logger.info("Restoring dimension providers...");
            for (i = 0; i < 3; ++i) {
                DimensionManager.unregisterDimension((int)(i - 1));
                DimensionManager.registerDimension((int)(i - 1), (DimensionType)origCache[i]);
            }
            if (abyssGrids != null) {
                for (i = 0; i < abyssDimIDs.length; ++i) {
                    DimensionManager.unregisterDimension((int)abyssDimIDs[i]);
                    DimensionManager.registerDimension((int)abyssDimIDs[i], (DimensionType)abyssNorm[i]);
                }
            }
            inUse = false;
        }
    }

    static {
        inUse = false;
        origCache = new DimensionType[3];
        gridCache = new DimensionType[3];
    }
}

