/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.building.placement;

import com.direwolf20.buildinggadgets.common.building.IPlacementSequence;
import com.direwolf20.buildinggadgets.common.building.Region;
import com.direwolf20.buildinggadgets.common.building.placement.Wall;
import com.direwolf20.buildinggadgets.common.tools.VectorTools;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.AbstractIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;

public final class ConnectedSurface
implements IPlacementSequence {
    private final IBlockAccess world;
    private final Region searchingRegion;
    private final Function<BlockPos, BlockPos> searching2referenceMapper;
    private final BlockPos searchingCenter;
    private final EnumFacing side;
    private final boolean fuzzy;

    public static ConnectedSurface create(IBlockAccess world, BlockPos searchingCenter, EnumFacing side, int range, boolean fuzzy) {
        Region searchingRegion = Wall.clickedSide(searchingCenter, side, range).getBoundingBox();
        return ConnectedSurface.create(world, searchingRegion, pos -> pos.func_177972_a(side), searchingCenter, side, fuzzy);
    }

    public static ConnectedSurface create(IBlockAccess world, Region searchingRegion, Function<BlockPos, BlockPos> searching2referenceMapper, BlockPos searchingCenter, EnumFacing side, boolean fuzzy) {
        return new ConnectedSurface(world, searchingRegion, searching2referenceMapper, searchingCenter, side, fuzzy);
    }

    @VisibleForTesting
    private ConnectedSurface(IBlockAccess world, Region searchingRegion, Function<BlockPos, BlockPos> searching2referenceMapper, BlockPos searchingCenter, EnumFacing side, boolean fuzzy) {
        this.world = world;
        this.searchingRegion = searchingRegion;
        this.searching2referenceMapper = searching2referenceMapper;
        this.searchingCenter = searchingCenter;
        this.side = side;
        this.fuzzy = fuzzy;
    }

    @Override
    public Region getBoundingBox() {
        return this.searchingRegion;
    }

    @Override
    public boolean mayContain(int x, int y, int z) {
        return this.searchingRegion.mayContain(x, y, z);
    }

    @Override
    public IPlacementSequence copy() {
        return new ConnectedSurface(this.world, this.searchingRegion, this.searching2referenceMapper, this.searchingCenter, this.side, this.fuzzy);
    }

    @Override
    @Nonnull
    public Iterator<BlockPos> iterator() {
        final IBlockState selectedBlock = this.getReferenceFor(this.searchingCenter);
        return new AbstractIterator<BlockPos>(){
            private Queue<BlockPos> queue;
            private ObjectSet<BlockPos> searched;
            {
                this.queue = new ArrayDeque<BlockPos>(ConnectedSurface.this.searchingRegion.size());
                this.searched = new ObjectOpenHashSet();
                this.queue.add(ConnectedSurface.this.searchingCenter);
                this.searched.add((Object)ConnectedSurface.this.searchingCenter);
            }

            protected BlockPos computeNext() {
                if (this.queue.isEmpty()) {
                    return (BlockPos)this.endOfData();
                }
                BlockPos current = this.queue.remove();
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        boolean isSearched;
                        BlockPos neighbor = VectorTools.perpendicularSurfaceOffset(current, ConnectedSurface.this.side, i, j);
                        boolean bl = isSearched = !this.searched.add((Object)neighbor);
                        if (isSearched || !ConnectedSurface.this.searchingRegion.contains((Vec3i)neighbor) || !ConnectedSurface.this.isStateValid(selectedBlock, neighbor)) continue;
                        this.queue.add(neighbor);
                    }
                }
                return current;
            }
        };
    }

    private boolean isStateValid(IBlockState filter, BlockPos pos) {
        IBlockState reference = this.getReferenceFor(pos);
        boolean isAir = reference.func_177230_c().isAir(reference, this.world, pos);
        if (this.fuzzy) {
            return !isAir;
        }
        return !isAir && filter == reference;
    }

    private IBlockState getReferenceFor(BlockPos pos) {
        return this.world.func_180495_p(this.searching2referenceMapper.apply(pos));
    }
}

