/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.tiles.analyzer;

import com.agricraft.agricore.core.AgriCore;
import com.google.common.base.Preconditions;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.misc.IAgriDisplayable;
import com.infinityraider.agricraft.api.v1.seed.AgriSeed;
import com.infinityraider.agricraft.init.AgriItems;
import com.infinityraider.agricraft.items.ItemJournal;
import com.infinityraider.agricraft.utility.StackHelper;
import com.infinityraider.infinitylib.block.tile.TileEntityRotatableBase;
import com.infinityraider.infinitylib.utility.inventory.IInventoryItemHandler;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class TileEntitySeedAnalyzer
extends TileEntityRotatableBase
implements ISidedInventory,
ITickable,
IAgriDisplayable,
IInventoryItemHandler {
    public static final int SPECIMEN_SLOT_ID = 36;
    public static final int JOURNAL_SLOT_ID = 37;
    private static final int[] SLOTS = new int[]{36, 37};
    @Nonnull
    private ItemStack specimen = ItemStack.field_190927_a;
    @Nonnull
    private ItemStack journal = ItemStack.field_190927_a;
    private int progress = 0;

    protected void writeRotatableTileNBT(NBTTagCompound tag) {
        if (!this.specimen.func_190926_b() && this.specimen.func_77973_b() != null) {
            NBTTagCompound seedTag = new NBTTagCompound();
            this.specimen.func_77955_b(seedTag);
            tag.func_74782_a("agri_seed", (NBTBase)seedTag);
        }
        if (!this.journal.func_190926_b() && this.journal.func_77973_b() != null) {
            NBTTagCompound journalTag = new NBTTagCompound();
            this.journal.func_77955_b(journalTag);
            tag.func_74782_a(AgriItems.getInstance().JOURNAL.func_77658_a(), (NBTBase)journalTag);
        }
        tag.func_74768_a("progress", this.progress);
    }

    protected void readRotatableTileNBT(NBTTagCompound tag) {
        this.specimen = tag.func_74764_b("agri_seed") ? new ItemStack(tag.func_74775_l("agri_seed")) : ItemStack.field_190927_a;
        this.journal = tag.func_74764_b(AgriItems.getInstance().JOURNAL.func_77658_a()) ? new ItemStack(tag.func_74775_l(AgriItems.getInstance().JOURNAL.func_77658_a())) : ItemStack.field_190927_a;
        this.progress = tag.func_74762_e("progress");
    }

    public final boolean hasSpecimen() {
        return this.hasSeed();
    }

    @Nonnull
    public final ItemStack getSpecimen() {
        return this.specimen;
    }

    public final boolean hasSeed() {
        return AgriApi.getSeedRegistry().hasAdapter(this.specimen);
    }

    public final void setProgress(int value) {
        this.progress = value;
    }

    public final int getProgress() {
        return this.progress;
    }

    public final int maxProgress() {
        return 100;
    }

    public static boolean isValid(ItemStack stack) {
        return AgriApi.getSeedRegistry().hasAdapter(stack);
    }

    public final boolean isSpecimenAnalyzed() {
        if (!this.specimen.func_190926_b()) {
            Optional<AgriSeed> seed = AgriApi.getSeedRegistry().valueOf(this.specimen);
            return seed.isPresent() && seed.get().getStat().isAnalyzed();
        }
        return false;
    }

    public void func_73660_a() {
        boolean change = false;
        if (this.isAnalyzing()) {
            int n = this.progress = this.progress < this.maxProgress() ? this.progress + 1 : this.maxProgress();
            if (this.progress == this.maxProgress() && !this.func_145831_w().field_72995_K) {
                this.analyze();
                change = true;
            }
        }
        if (change) {
            this.markForUpdate();
            this.func_145831_w().func_175641_c(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()).func_177230_c(), 0, 0);
            this.func_145831_w().func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
        }
    }

    public void analyze() {
        Optional<AgriSeed> wrapper = AgriApi.getSeedRegistry().valueOf(this.specimen);
        if (wrapper.isPresent()) {
            AgriSeed seed = wrapper.get();
            seed = seed.withStat(seed.getStat().withAnalyzed(true));
            seed.getStat().writeToNBT(StackHelper.getTag(this.specimen));
            if (this.hasJournal()) {
                ((ItemJournal)this.journal.func_77973_b()).addEntry(this.journal, seed.getPlant());
            }
        }
    }

    public final boolean isAnalyzing() {
        return !this.specimen.func_190926_b() && !this.isSpecimenAnalyzed() && this.progress < this.maxProgress();
    }

    public final boolean hasJournal() {
        return !this.journal.func_190926_b() && this.journal.func_77973_b() != null;
    }

    public final ItemStack getJournal() {
        return this.journal;
    }

    public final int getProgressScaled(int scale) {
        return Math.round((float)this.progress * (float)scale / (float)this.maxProgress());
    }

    public int[] func_180463_a(EnumFacing side) {
        return SLOTS;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing direction) {
        switch (slot) {
            case 36: {
                return TileEntitySeedAnalyzer.isValid(stack);
            }
            case 37: {
                return this.journal.func_190926_b() && this.func_94041_b(slot, stack);
            }
        }
        return false;
    }

    public boolean func_180461_b(int slot, ItemStack itemStackIn, EnumFacing direction) {
        if (slot == 36 && !this.specimen.func_190926_b() && this.specimen.func_77942_o()) {
            return this.isSpecimenAnalyzed();
        }
        return false;
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int slot) {
        switch (slot) {
            case 36: {
                return this.specimen;
            }
            case 37: {
                return this.journal;
            }
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack output = ItemStack.field_190927_a;
        switch (slot) {
            case 36: {
                if (this.specimen.func_190926_b()) break;
                if (amount < this.specimen.func_190916_E()) {
                    output = this.specimen.func_77979_a(amount);
                    break;
                }
                output = this.specimen.func_77946_l();
                this.specimen = ItemStack.field_190927_a;
                this.progress = 0;
                this.markForUpdate();
                break;
            }
            case 37: {
                if (this.journal.func_190926_b()) break;
                output = this.journal.func_77946_l();
                this.journal = ItemStack.field_190927_a;
                this.markForUpdate();
            }
        }
        return output;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack result;
        switch (slot) {
            case 36: {
                result = this.specimen;
                this.specimen = ItemStack.field_190927_a;
                this.progress = 0;
                break;
            }
            case 37: {
                result = this.journal;
                this.journal = ItemStack.field_190927_a;
                break;
            }
            default: {
                return ItemStack.field_190927_a;
            }
        }
        this.markForUpdate();
        return result;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (stack == null) {
            stack = ItemStack.field_190927_a;
        }
        switch (slot) {
            case 36: {
                this.specimen = stack;
                if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
                    stack.func_190920_e(this.func_70297_j_());
                }
                this.progress = this.isSpecimenAnalyzed() ? this.maxProgress() : 0;
                break;
            }
            case 37: {
                this.journal = stack;
            }
        }
        Optional<AgriSeed> seed = AgriApi.getSeedRegistry().valueOf(this.specimen);
        if (seed.isPresent()) {
            this.specimen = seed.get().toStack(this.specimen.func_190916_E());
            if (this.hasJournal() && seed.get().getStat().isAnalyzed()) {
                ((ItemJournal)this.journal.func_77973_b()).addEntry(this.journal, seed.get().getPlant());
            }
        }
        this.markForUpdate();
    }

    public final int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.func_145831_w().func_175625_s(this.field_174879_c) == this && player.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        switch (slot) {
            case 36: {
                return TileEntitySeedAnalyzer.isValid(stack);
            }
            case 37: {
                return StackHelper.isValid(stack, ItemJournal.class);
            }
        }
        return false;
    }

    public String func_70005_c_() {
        return "container.agricraft:seedAnalyzer";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString("container.agricraft:seedAnalyzer");
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.specimen = ItemStack.field_190927_a;
        this.journal = ItemStack.field_190927_a;
    }

    @Override
    public void addDisplayInfo(@Nonnull Consumer<String> information) {
        Preconditions.checkNotNull(information);
        information.accept(AgriCore.getTranslator().translate("agricraft_tooltip.analyzer") + ": " + (this.hasSpecimen() ? this.specimen.func_82833_r() : AgriCore.getTranslator().translate("agricraft_tooltip.none")));
    }
}

